; RDNUM.INC
; convert Strings to Words (unsigned)
; (c) 1/1994  Jan Laitenberger
; Assembler: JASMIN

; @Val: convert STRING -> WORD
; (1st char = length)
; parameters: I - BX: base system
;		  SI: string offset
;             O - CF=0: Ok
;	 	  CF=1: error
;		    AX: position

@Val:	PUSH	CX
	PUSH	DX
	PUSH	SI
	XOR	CX, CX
	XOR	DX, DX
	LODSB
	MOV	CL, AL
@NChr:	XOR	AH, AH
	LODSB
	CMP	AL, 60h
	JB	@X0
	SUB	AL, 20h
@X0:	SUB	AL, 30h
	CMP	AL, 9
	JBE	@X1
	SUB	AL, 7
@X1:	CMP	AX, BX
	JNL	@RdErr
	CMP	AL, 0
	JL	@RdErr
	ADD	AX, DX
	CMP	CL, 1
	JE	@VExit
	MUL	BX
	MOV	DX, AX
	LOOP	@NChr
@VExit:	POP	SI	
	POP	DX
	POP	CX
	CLC
	RET
@RdErr:	POP	SI
	POP	DX
	XOR	AH, AH
	MOV	AL, [SI]
	SUB	AL, CL
	INC	AL
	POP	CX
	STC
	RET

; determine base of a number, which
; depends on the last character
; (b-binary, d-decimal, h-hexadecimal)
; if the number doesn't terminate with
; one of these characters, the base
; system will be set to decimal,
; otherwise the string length will be
; decremented
; Parameter: I - DI: string offset
;	     O - BX: base system

@GetSys:PUSH	AX
	PUSH	CX
	XOR	BH, BH
 	MOV	BL, [SI]
	MOV	CX, 10
	CMP	BL, 1
	JBE	@GExit
 	MOV	AL, [SI+BX]
	CMP	AL, 60h
	JB	@X3
	SUB	AL, 20h
@X3:	XOR	CH, CH
	MOV	CL, 16
	CMP	AL, 72
	JE	@Equal
	SUB	CL, 14
	CMP	AL, 66
	JE	@Equal
	ADD	CL, 8
	CMP	AL, 68
	JE	@Equal
@GExit:	MOV	BX, CX
	POP	CX
	POP	AX
	RET
@Equal: DEC	BYTEPTR[SI]
        JMP	SHORT @GExit
