; WRNUM.INC
; convert BYTE/WORD -> STRING,
; format and display ...
; (c) 6/1991  Jan Laitenberger
; Assembler: JASMIN

; @STR: converts number to string
; (1st character = length)
; Parameter: I - AX: number
;		 BX: base system
;		 DI: string offset

@Str:	PUSH	AX
	PUSH	CX 
	PUSH	DX 
	PUSH	DI
	XOR	CX, CX
@0:	XOR	DX, DX 
	DIV	BX 
	ADD	DL, 30h 
	CMP	DL, 39h 
	JBE	@1 
	ADD	DL, 7 
@1:	PUSH	DX 
	INC	CX
	CMP	AX, 0
	JNE	@0
	MOV	AL, CL
	STOSB
@2:	POP	AX
	STOSB 
	LOOP	@2
	POP	DI
	POP	DX 
	POP	CX
	POP	AX
	RET

; @WrtNum: display a WORD
; parameters: I - AX: number
;		  BX: base system

@WrNum:	PUSH	AX
	PUSH	CX 
	PUSH	DX 
	XOR	CX, CX
@W0:	XOR	DX, DX 
	DIV	BX 
	ADD	DL, 30h 
	CMP	DL, 39h 
	JBE	@W1 
	ADD	DL, 7 
@W1:	PUSH	DX 
	INC	CX
	CMP	AX, 0
	JNE	@W0
@W2:	POP	AX
	MOV	AH, 0Eh
	INT	10h
	LOOP	@W2
	POP	DX 
	POP	CX
	POP	AX
	RET

; @Wrt: display a string
; parameters: I - SI: offset adress

@Wrt:	PUSH	AX
	PUSH	CX
	LODSB
	XOR	AH, AH
	XCHG	AX, CX
@3:	LODSB
	MOV	AH, 0Eh
	INT	10h
	LOOP	@3
	POP	CX
	POP	AX
	RET

; @Form: formats a string to given
; length (append fill character to
; beginning of string)
; parameters: I - AL: new length
;		  AH: fill char
;		  SI: source string offset
;		  DI: target string offset

@Form:	PUSH AX
	PUSH CX
	MOV  CL, AL
	LODSB	
	PUSH AX
	CMP  CL, AL
	MOV  BYTE PTR [DI-1], AL
	JBE  @NoBlk
	MOV  BYTE PTR [DI-1], CL
	SUB  CL, AL
	MOV  AL, AH
	REPZ
	STOSB
@NoBlk:	POP  CX
	XOR  CH, CH
	REPZ
	MOVSB			
	POP  CX
	POP  AX
	RET