/**********************************************************
**
**
** Tennis Zhl Programm nach der Idee von Martin Schrder
** neu in C fr den Atari Portfolio  programmiert
**
** Start 31.03.1995
**
***********************************************************/

/*Includes .. */
	#include <stdio.h>
	#include <stdlib.h>
	#include <conio.h>
	#include <io.h>
	#include <dos.h>
	#include <sys\stat.h>
	#include <dir.h>
	#include <string.h>
	#include <FCNTL.H>
	#include <TIME.h>

/* defines ... */
	#define breite 40;
	#define hoehe 8;
	#define MAXFILES 50

/* definieren der Tasten */
	#define UARROW  0x48
	#define DARROW  0x50
	#define LARROW  0x4b
	#define RARROW  0x4d
	#define BS      0x0e
	#define DEL     0x53
	#define RET     13
	#define ESC     27
	#define SPACE   32
	#define TAB     0x09

/* Typen deklaration */

	/* Boolean Type einfhren */
	typedef enum
	{
		FALSE=0,
		TRUE=1
	}boolean;

	struct SPIELER
	{
		char name[14];
		int punkte;
		int spiele[5];
		boolean einstand;
		boolean aufschlag;
		int satz;
	};
	struct SPIEL
	{
		SPIELER name1, name2;
		int satzzahl;
		int baelle;
		int spielart;
		int b,d,p,r,v,g,u,t,n,a,s;
		boolean ende;
		int min;
	};


/* fr Io Krams */

	struct ffblk dateiblock;


/* Prototypen Deklaration */
	void main(void);
	void init(void);
	void save_spiel(void);
	void fill(void);
	void a_wechsel(void);
	void s_wechsel(void);
	void info(void);
	void pruefen(void);
	void edit_spiel(void);
	void neu(void);
	void gewonnen(char name[12]);
	void t_stat(void);
	void tiebreak(void);
	void undo(int was);
	boolean load_spiel(void);
	void dir_spiele(void);
	void abfrage(void);
	void set_time(void);
	void save_tstat();
	boolean drucken(void);
	boolean drucken_ballstat(char spielername[30]);


/* globale Variablen */
	SPIEL spiel;
	SPIELER save1, save2;
	boolean save=FALSE;
	int i;
	struct time zeit;
	char z_puf[9],
		 d_puf[9],
		 puffer[500],
		 c;
	int akut_min;

/******************************************************************************/

void main(void)
{
	int ende=FALSE;		/* Logische Variablen */
	long int i;
	int j;

	/* Turn off the cursor */
	/*_setcursortype(_NOCURSOR);*/

	/* Switch to a solid cursor
	_setcursortype(_SOLIDCURSOR);

	Switch back to the normal cursor
	_setcursortype(_NORMALCURSOR);

	*/


	/* Initialisieren der felder */
	spiel.name1.einstand=spiel.name2.einstand=FALSE;
	spiel.name1.name[0]=spiel.name2.name[0]=0;
	spiel.name1.punkte=spiel.name2.punkte=0;
	for(j=0;j<5;j++)
		spiel.name1.spiele[j]=spiel.name2.spiele[j]=0;
	spiel.name1.aufschlag=spiel.name2.aufschlag=FALSE;
	spiel.spielart =2;

	/* Auf Cheftastendruck warten :-)) */
	for(i=10000;i!=0;i--);

	/* Kleines Intro */
	if(kbhit())
	{
		if(getch()!=ESC)
		{
			clrscr();
			gotoxy(7,4);printf(" Tennis Profi ۲  ");
			for(i=0xFFFF;i!=0;i--);
			gotoxy(7,4);printf("  Version 1.00 fr      ");
			for(i=0xFFFF;i!=0;i--);
			gotoxy(7,4);printf("den Portfolio Club Deutschland");
			for(i=0xFFFF;i!=0;i--);
			clrscr();
			gotoxy(2,4);printf(" nach einer Idee von Martin Schrder");
			for(i=0xFFFF;i!=0;i--);
			gotoxy(2,4);printf("      In C fr den POFO von          ");
			for(i=0xFFFF;i!=0;i--);
			gotoxy(2,4);printf("       Michael Schrder (R)1997   \n               (R)1995");
			for(i=0xFFFF;i!=0;i--);
		}
		else
		{
			clrscr();
			gotoxy(10,4);printf("  Hallo Chef !  ");
			getch();
		};
	}
	else
	{
		clrscr();
		gotoxy(7,4);printf(" Tennis Profi ۲  ");
		for(i=0xFFFF;i!=0;i--);
		gotoxy(7,4);printf("     Version 1.00      ");
		for(i=0xFFFF;i!=0;i--);
		gotoxy(7,4);printf("     vom 08.05.95      ");
		for(i=0xFFFF;i!=0;i--);
		clrscr();
		gotoxy(2,4);printf(" nach einer Idee von Martin Schrder");
		for(i=0xFFFF;i!=0;i--);
		gotoxy(2,4);printf("      In C fr den POFO von          ");
		for(i=0xFFFF;i!=0;i--);
		gotoxy(2,4);printf("           Michael Schrder         \n               (R)1995");
		for(i=0xFFFF;i!=0;i--);
	};

	do
	{

		/* Menu auf den Schirm und auf den Benutzerdruck warten */
		clrscr();
		gotoxy(1,1);printf("͹TenPro͹ Menue ͹ Ver.1.00 ");
		gotoxy(1,8);printf("");
		gotoxy(8,2);printf("(N)eues Spiel  beginnen");
		gotoxy(8,3);printf("(L)aden  eines  Spieles");
		gotoxy(8,4);printf("(D)irectory     ansehen");
		gotoxy(8,5);printf("(E)ingabe eines Spieles");
		gotoxy(8,6);printf("(T)rainings   Statistik");
		gotoxy(8,7);printf("(ESC)   TenPro  beenden");
		c=getch();

		/* Wir reagieren */
		switch(c)
		{
			case 'N':
			case 'n':
				neu();
				spiel.ende=FALSE;
				abfrage();
			break;
			case 'L':
			case 'l':
				if(load_spiel())
				{
					spiel.ende=FALSE;
					abfrage();
				};
			break;
			case 'D':
			case 'd':
				dir_spiele();
			break;
			case 'E':
			case 'e':
				edit_spiel();
				spiel.ende=FALSE;
				abfrage();
			case 'T':
			case 't':
				t_stat();
			break;

			case 'P':
			case 'p':
				drucken();
			break;

			/* Zeit anzeigen */
			case 'z':
			case 'Z':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(5,3);printf("   Heute ist der %s.",d_puf);
				do
				{
					if(i!=zeit.ti_sec)
					{
						gotoxy(5,6);printf("   Es ist %s Uhr.",z_puf);
						i=zeit.ti_sec;
					};
					set_time();
				}while(!kbhit());
			break;

			/* Programminfo zeigen*/
			case 'i':
			case 'I':
				info();
			break;

			/* Spielstand speichern */
			case 's':
			case 'S':
				save_spiel();
			break;

			/* Hilfe anzeigen */
			case 'h':
			case 'H':
				clrscr();
				gotoxy(2,1);printf("TenPro Menu           Tastenbelegung(1)");
				gotoxy(2,2);printf("N  = Neuse Spiel beginnen");
				gotoxy(2,3);printf("L  = Alten Spielstand speichern");
				gotoxy(2,4);printf("D  = Directory ansehen    ");
				gotoxy(2,5);printf("H  = diese Seiten  ");
				gotoxy(2,6);printf("P  = Drucken ");
				gotoxy(2,7);printf("Z  = Zeit anzeigen      ");
				gotoxy(2,8);printf("Mit beliebiger Taste weiter ...");
				getch();
				clrscr();
				gotoxy(2,1);printf("TenPro Menu           Tastenbelegung(2)");
				gotoxy(2,2);printf("I   = Info anzeigen              ");
				gotoxy(2,3);printf("ESC = Ende von Spiel");
				gotoxy(2,4);printf("E   = Eingabe eines Speilstandes");
				gotoxy(2,8);printf("Ende mit beliebiger Taste  ...");
				getch();
			break;
			case ESC:

				clrscr();
				gotoxy(9,4);printf("TenPro abbrechen ? (J/N)");
				c=getch();
				if(c=='J'||c=='j')
					ende=TRUE;
				if(save)
				{
					clrscr();
					gotoxy(2,3);printf("Spielstand wurde noch nicht gesichert");
					gotoxy(2,6);printf("  Altes Spiel jetzt sichern ?(J/N)");
					c=getch();
					if(c=='J'||c=='j')
						save_spiel();
				};
			break;
		};
	}while(!ende);

	clrscr();
	gotoxy(2,5);printf("    TenPro wurde beendet ....");
	gotoxy(2,7);printf("       Schnen Tag noch ...");

};

/*********************************************************
**
** abfrage()
** =======
** (R) Michael Schrder 5.5.1995
**
** Tastaturabfrage zum Zhlen und so weiter
** -> nichts
** <- nichts
**
**********************************************************/
void abfrage(void)
{
	int ende=1;		/* Logische Variablen */

	do
	{
		/* Spiel luft, Zeit messen */
		set_time();
		if(zeit.ti_min!=akut_min)
		{
			spiel.min++;
			gotoxy(18,1);printf("%d",spiel.min);
			akut_min=zeit.ti_min;
		};


	/* Schleife zur Tasten Abfrage */
	if(kbhit())
	{
		c=getch();
		switch(c)
		{
			/* Punkt linker Spieler */
			case LARROW:
				switch(spiel.name1.punkte)
				{
					case 0:
					case 15:
						undo(1);
						spiel.name1.punkte+=15;
					break;
					case 30:
					case 40:
					case 50:
						undo(1);
						spiel.name1.punkte+=10;
					break;
				 };
				 spiel.baelle++;
				 pruefen();
				 fill();
				 save=TRUE;
			break;

			/* Punkt rechter Spieler */
			case RARROW:
				switch(spiel.name2.punkte)
				{
					case 0:
					case 15:
						undo(1);
						spiel.name2.punkte+=15;
					break;
					case 30:
					case 40:
					case 50:
						undo(1);
						spiel.name2.punkte+=10;
					break;
				 };
				 spiel.baelle++;
				 pruefen();
				 fill();
				 save=TRUE;
			break;

			case ESC:
				/* Spielabbruch */
				clrscr();
				gotoxy(9,4);printf("Spiel abbrechen ? (J/N)");
				c=getch();
				if(c=='J'||c=='j')
				{
					if(save)
					{
						clrscr();
						gotoxy(12,4);printf("Spiel abgebrochen");
						getch();
					};
					clrscr();
					ende=FALSE;
				}
				else
				{
					init();
					fill();
				};
			break; /* Spielabbruch */
			/* Neuse Spiel anfangen */
			case 'n':
			case 'N':
				neu();
			break;

			/* Hilfe anzeigen */
			case 'h':
			case 'H':
				clrscr();
				gotoxy(2,1);printf("TenPro Version 1.00   Tastenbelegung(1)");
				gotoxy(2,2);printf("<- Punkt fr linken Spieler");
				gotoxy(2,3);printf("-> Punkt fr rechten Spieler");
				gotoxy(2,4);printf("N  = neunes Spiel anfangen");
				gotoxy(2,5);printf("H  = diese Seiten  ");
				gotoxy(2,6);printf("S  = Spielstand speichern ");
				gotoxy(2,7);printf("U  = Undo letzte Eingabe");
				gotoxy(2,8);printf("Mit beliebiger Taste weiter ...");
				getch();
				clrscr();
				gotoxy(2,1);printf("TenPro Version 1.00   Tastenbelegung(2)");
				gotoxy(2,2);printf("E   = Eingabe eines Spielstandes ");
				gotoxy(2,3);printf("TAB = Seitenwechsel");
				gotoxy(2,4);printf("A   = Aufschlagwechsel");
				gotoxy(2,5);printf("L   = Spielstand laden");
				gotoxy(2,6);printf("D   = gespeicherte Spielstnde listen ");
				gotoxy(2,7);printf("I   = Programminfo anzeigen  "    );
				gotoxy(2,8);printf("Weiter mit beliebiger Taste  ...");
				getch();
				clrscr();
				gotoxy(2,1);printf("TenPro Version 1.00   Tastenbelegung(3)");
				gotoxy(2,2);printf("2   = Zwei Gewinnstze ");
				gotoxy(2,3);printf("3   = Drei Gewinnstze");
				gotoxy(2,4);printf("T   = Tranigsstatistik");
				gotoxy(2,5);printf("Z   =  Zeigt Datum und Zeit an");
				gotoxy(2,6);printf("ESC = Abbruch des Spieles  ");
				gotoxy(2,7);printf("P   = Spielpause einschalten "    );
				gotoxy(2,8);printf("Ende mit beliebiger Taste  ...");
				getch();
				init();
				fill();
			break; /* Hilfe */

			/* Aufschlagwechsel */
			case 'a':
			case 'A':
				save=TRUE;
				a_wechsel();
			break;

			/* Seitenwechsel */
			case TAB:
				save=TRUE;
				s_wechsel();
				init();
				fill();
			break;

			/* Spielstand speichern */
			case 's':
			case 'S':
				save_spiel();
			break;

			/* Spielstand laden */
			case 'l':
			case 'L':
				load_spiel();
				pruefen();
			break;

			/* Spielstnde listen */
			case 'd':
			case 'D':
				dir_spiele();
				init();
				fill();
			break;

			/* Spielstand eingeben */
			case 'e':
			case 'E':
				edit_spiel();
			break;

			/* Programminfo zeigen*/
			case 'i':
			case 'I':
				info();
				init();
				fill();
			break;

			/* Zeit anzeigen */
			case 'z':
			case 'Z':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(5,3);printf("Heute ist der %s.",d_puf);
				do
				{
					if(i!=zeit.ti_sec)
					{
						gotoxy(5,6);printf("   Es ist %s Uhr.",z_puf);
						i=zeit.ti_sec;
					};
					set_time();
				}while(!kbhit());
				init();
				fill();

			break;
			/* Zeit anzeigen */
			case 'p':
			case 'P':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(1,3);printf("      Pausenanfang: %s",z_puf);
				do
				{
					if(i!=zeit.ti_sec)
					{
						gotoxy(5,5);printf("  Aktuelle Zeit %s  ",z_puf);
						i=zeit.ti_sec;
					};
					set_time();
				}while(!kbhit());
				init();
				fill();

			break;

			/* 2 Satzeinstellen */
			case '2':
				spiel.spielart =2;
				init();
				fill();
				pruefen();
			break;

			/* 3 Satz einstellen*/
			case '3':
				spiel.spielart=3;
				init();
				fill();
				pruefen();
			break;

			/* Trainerstatistik */
			case 't':
			case 'T':
				t_stat();
				init();
				fill();
			break;
			case 'u':
			case 'U':
				undo(0);
				init();
				fill();
			break;
		};
		if(spiel.ende)
			ende=FALSE;
	};
	}while(ende);
};
/*********************************************************
**
** init()
** =======
** (R) Michael Schrder 31.03.1995
**
** Schreibt den Bildschirm voll mit allen wichtigen Werten
** -> nichts
** <- nichts
**
**********************************************************/
void init(void)
{
	clrscr();

	gotoxy(1,1);printf("͹TenPro͹   ͹ Version 1.00 ");
	gotoxy(1,8);printf("");
	gotoxy(18,1);printf("%d",spiel.min);
	gotoxy(1,2); printf( "Links :");
	gotoxy(21,2); printf("Rechts:");
	gotoxy(1,3); printf("Punkte:");
	gotoxy(21,3);printf("Punkte:");
	gotoxy(5,4);printf("Aufschlag:");
	gotoxy(25,4);printf("Aufschlag:");
	gotoxy(1,5);printf("Satz:");
	gotoxy(21,5);printf("Satz:");
	gotoxy(6,6); printf(" 12345");
	gotoxy(26,6);printf(" 12345");
};

/*********************************************************
**
** fill()
** =============
** (R) Michael Schrder 02.04.1995
**
** llt den Bildschirm mit den Variablen Werten
**
** -> nichts
** <- nichts
**
**********************************************************/
void fill(void)
{
	/* Fr Spieler links */
	gotoxy(8,2);printf("%s",spiel.name1.name);
	gotoxy(9,3);
	if(spiel.name1.einstand)
		printf("Einstand ");
	else if(spiel.name1.punkte<50)
		printf("%d         ",spiel.name1.punkte);
	else
		printf("Vorteil  ");
	gotoxy(16,4);
	if(spiel.name1.aufschlag)
		printf("*");
	for(i=0;i<=spiel.satzzahl;i++)
		{gotoxy(7+i,5);printf("%d",spiel.name1.spiele[i]);}

	/* Fr Spieler rechts*/
	gotoxy(28,2);printf("%s",spiel.name2.name);
	gotoxy(29,3);
	if(spiel.name2.einstand)
		printf("Einstand ");
	else if(spiel.name2.punkte<50)
		printf("%d         ",spiel.name2.punkte);
	else
		printf("Vorteil  ");
	gotoxy(36,4);
	if(spiel.name2.aufschlag)
		printf("*");
	for(i=0;i<=spiel.satzzahl;i++)
		{gotoxy(27+i,5);printf("%d",spiel.name2.spiele[i]);}

	gotoxy(2,8);printf(" Blle: %d ", spiel.baelle);
	gotoxy(20,8);printf(" %d Gewinnstze ",spiel.spielart);

};
/*********************************************************
**
** a_wechsel()
** =============
** (R) Michael Schrder 02.04.1995
**
** Aufschalgwechsel, bzw Eingabe wenn nicht gesetzt
**
** -> nichts
** <- nichts
**
**********************************************************/
void a_wechsel(void)
{
	if(spiel.name1.aufschlag==FALSE && spiel.name2.aufschlag==FALSE)
	{
		clrscr();
		gotoxy(2,2);printf("    Wer soll Aufschlag haben? (R/L)");
		c=getch();
		if((c=='r')||(c=='R'))
		{
			spiel.name2.aufschlag=TRUE;
		}
		else
		{
			spiel.name1.aufschlag=TRUE;
		};
	}
	else
	{
		if(spiel.name1.aufschlag)
		{
			spiel.name1.aufschlag=FALSE;
			spiel.name2.aufschlag=TRUE;
		}
		else
		{
			spiel.name2.aufschlag=FALSE;
			spiel.name1.aufschlag=TRUE;
		};
	};
	init();
	fill();
};

/*********************************************************
**
** s_wechsel()
** =============
** (R) Michael Schrder 02.04.1995
**
** Kopiert alles Daten vom Linken auf den rechten Spiler und
** umgekeht
**
** -> nichts
** <- nichts
**
**********************************************************/
void s_wechsel(void)
{
	SPIELER dummy;

	gotoxy(1,7);printf("          - SEITEN WECHSEL -");
	while(getch()!=RET);

	/* Daten rum copieren */
	dummy.punkte=spiel.name1.punkte;
	for(i=0;i<6;i++)
		dummy.spiele[i]=spiel.name1.spiele[i];
	dummy.aufschlag=spiel.name1.aufschlag;
	dummy.einstand=spiel.name1.einstand;
	strcpy (dummy.name, spiel.name1.name);
	dummy.satz=spiel.name1.satz;

	spiel.name1.punkte=spiel.name2.punkte;
	for(i=0;i<6;i++)
		spiel.name1.spiele[i]=spiel.name2.spiele[i];
	spiel.name1.aufschlag=spiel.name2.aufschlag;
	spiel.name1.einstand=spiel.name2.einstand;
	strcpy (spiel.name1.name, spiel.name2.name);
	spiel.name1.satz=spiel.name2.satz;

	spiel.name2.punkte=dummy.punkte;
	for(i=0;i<6;i++)
		spiel.name2.spiele[i]=dummy.spiele[i];
	spiel.name2.aufschlag=dummy.aufschlag;
	spiel.name2.einstand=dummy.einstand;
	strcpy (spiel.name2.name, dummy.name);
	spiel.name2.satz=dummy.satz;

	gotoxy(1,7);printf("                             ");
};
/*********************************************************
**
** edit_spiel()
** =============
** (R) Michael Schrder 02.04.1995
**
** Eingeben oder nderen eines Spielstandes
**
** -> nichts
** <- nichts
**
**********************************************************/
void edit_spiel(void)
{
	if(save)
	{
		clrscr();
		gotoxy(2,3);printf("Spielstand wurde noch nicht gesichert");
		gotoxy(2,6);printf("  Spielstand jetzt sichern ?(J/N)");
		c=getch();
		if(c=='J'||c=='j')
			save_spiel();
	};

	/* Aufschlag zurck setzten */
	spiel.name1.einstand=FALSE;
	spiel.name1.aufschlag=FALSE;
	spiel.name2.einstand=FALSE;
	spiel.name2.aufschlag=FALSE;

	/* Namen eingeben */
	clrscr();
	gotoxy(1,2);printf("  Bitte Namen des \n  linken Spielers eingeben:");
	gotoxy(5,6);printf("___________");
	gotoxy(5,5);scanf("%s",spiel.name1.name);
	spiel.name1.name[12]=0;
	clrscr();
	gotoxy(1,2);printf("  Bitte Namen des \n  rechten Spielers eingeben:");
	gotoxy(5,6);printf("___________");
	gotoxy(5,5);scanf("%s",spiel.name2.name);
	spiel.name2.name[12]=0;

	/* Bilschrilm holen */
	init();
	fill();

	/* Drberscheiben */
	gotoxy(1,1);printf(" Spielstandeingabe 15,30,40,60=Vort. ");

	/* Eingabe solange bis richtig */
	while(TRUE)
	{
		gotoxy(2,7);printf("                                        ");
		gotoxy(2,7);printf(" Wieviel Stze?: ");
		scanf("%d",&spiel.satzzahl);
		if((spiel.satzzahl>=1)&&(spiel.satzzahl<=5))
		{
			spiel.satzzahl--;
			break;
		};
		gotoxy(2,7);printf("Falsche Eingabe bitte 1 - 5 eingeben!!");
		getch();
	};
	gotoxy(2,7);printf("                                ");

	/* Und wieder die Kontrolle der Eingabe ... */
	while(TRUE)
	{
		gotoxy(9,3);scanf("%d",&spiel.name1.punkte);
		gotoxy(2,7);printf("                                        ");
		switch(spiel.name1.punkte)
		{
			case 15:
			case 30:
			case 40:
			case 60:
				break;
			default:
				gotoxy(2,7);printf("Bitte: 15, 30, 40, 60 eingeben !! ");
				getch();
				spiel.name1.punkte=0;
				break;
		};
		if(spiel.name1.punkte)
			break;
	};

	while(TRUE)
	{
		gotoxy(29,3);scanf("%d",&spiel.name2.punkte);
		gotoxy(2,7);printf("                                        ");
		switch(spiel.name2.punkte)
		{
			case 15:
			case 30:
			case 40:
			case 60:
				break;
			default:
				gotoxy(2,7);printf("Bitte: 15, 30, 40, 60 eingeben !! ");
				getch();
				spiel.name2.punkte=0;
				break;
		};
		if(spiel.name2.punkte)
			break;
	};

	if((spiel.name1.punkte==40)&&(spiel.name2.punkte==40))
		spiel.name1.einstand=spiel.name2.einstand=TRUE;

	/* Satzeingabe und Kontrolle ob hier keiner Schrott eingibt */
	/* Spieler Links */
	for(i=0;i<=spiel.satzzahl;i++)
	{
		while(TRUE)
		{
			gotoxy(7+i,5);
			scanf("%d",&spiel.name1.spiele[i]);
			gotoxy(2,7);printf("                                       ");
			if((spiel.name1.spiele[i]>=1)&&(spiel.name1.spiele[i]<=7))
			{
				if(spiel.name1.spiele[i]>=6)
					spiel.name1.satz++;
				break;
			};
			gotoxy(2,7);printf("Falsche Eingabe bitte 1 - 7 eingeben !!");
		};
	};

	/* Spieler rechts  */
	for(i=0;i<=spiel.satzzahl;i++)
	{
		while(TRUE)
		{
			gotoxy(27+i,5);
			scanf("%d",&spiel.name2.spiele[i]);
			gotoxy(2,7);printf("                                      ");
			if((spiel.name2.spiele[i]>=1)&&(spiel.name2.spiele[i]<=7))
			{
				if(spiel.name2.spiele[i]>=6)
					spiel.name2.satz++;
				break;
			};
			gotoxy(2,7);printf("Falsche Eingabe bitte 1 - 7 eingeben !!");
		};
	};

	/* Spielanfang setzen */
	save=TRUE;
	spiel.min=0;

	/* Aufschlag setzen */
	a_wechsel();

	/* und Bild her */
	init();
	fill();

	/* Hat da schon einer gewonnen ??? */
	pruefen();

};
/*********************************************************
**
** info_()
** =============
** (R) Michael Schrder 02.04.1995
**
**  :-)
** -> nichts
** <- nichts
**
**********************************************************/
void info(void)
{
	clrscr();
	gotoxy(1,1);printf("");
	gotoxy(1,8);printf("");
	gotoxy(1,3);printf("         TenPro  Version 1.00  ");
	gotoxy(1,4);printf("             vom 08.05.95     ");
	gotoxy(1,6);printf("             VOLL Version    ");
	getch();
	clrscr();
	gotoxy(1,1);printf("");
	gotoxy(1,8);printf("");
	gotoxy(1,2);printf("Nach einer Idee von: ");
	gotoxy(1,3);printf("                        Martin Schrder");
	gotoxy(1,6);printf("Programiert in C fr den Portfolio :");
	gotoxy(1,7);printf("                       Michael Schrder");
	getch();
};
/*********************************************************
**
** prfen()
** =============
** (R) Michael Schrder 03.04.1995
**
**  Prft den Spielstand und leitet Manahmen ein
** -> nichts
** <- nichts
**
**********************************************************/
void pruefen(void)
{
	boolean jo=FALSE;

	/* Spiele zhlen */
	/* linker Spieler bekommt einen Punkt */
	switch(spiel.name1.punkte)
	{
		case 50:
			switch(spiel.name2.punkte)
			{
				case 0:
				case 15:
				case 30:
					/* Seitenwechsel ermitteln */
					if(!((spiel.name1.spiele[spiel.satzzahl]+spiel.name2.spiele[spiel.satzzahl])%2))
						jo=TRUE;

					spiel.name1.spiele[spiel.satzzahl]++;
					spiel.name2.punkte=spiel.name1.punkte=0;

					if(jo)s_wechsel();

					a_wechsel();
				break;
			};
		break;
		case 60:
			if(spiel.name2.punkte==40)
			{
				/* Seitenwechsel ermitteln */
				if(!((spiel.name1.spiele[spiel.satzzahl]+spiel.name2.spiele[spiel.satzzahl])%2))
					jo=TRUE;

				spiel.name1.spiele[spiel.satzzahl]++;
				spiel.name2.punkte=spiel.name1.punkte=0;

				if(jo)s_wechsel();

				a_wechsel();
			}
		break;
	};

	/* rechter Spieler bekommt einen Punkt */
	switch(spiel.name2.punkte)
	{
		case 50:
			switch(spiel.name1.punkte)
			{
				case 0:
				case 15:
				case 30:
				  /* Seitenwechsel ermitteln */
					if(!((spiel.name1.spiele[spiel.satzzahl]+spiel.name2.spiele[spiel.satzzahl])%2))
						jo=TRUE;

					spiel.name2.spiele[spiel.satzzahl]++;
					spiel.name1.punkte=spiel.name2.punkte=0;

					if(jo)s_wechsel();

					a_wechsel();
				break;
			};
		break;
		case 60:
			if(spiel.name1.punkte==40)
			{
				/* Seitenwechsel ermitteln */
				if(!((spiel.name1.spiele[spiel.satzzahl]+spiel.name2.spiele[spiel.satzzahl])%2))
					jo=TRUE;

				spiel.name2.spiele[spiel.satzzahl]++;
				spiel.name1.punkte=spiel.name2.punkte=0;

				if(jo)s_wechsel();

				a_wechsel();
			}
		break;
	};

  /*Einstand erkennen setzen */
  if((spiel.name1.punkte==50)&&(spiel.name2.punkte==50)||
	  (spiel.name1.punkte==40)&&(spiel.name2.punkte==40) )
  {
		spiel.name1.punkte=spiel.name2.punkte=40;
		spiel.name1.einstand=spiel.name2.einstand=TRUE;
  };

  /*Vorteil erkennen und Einstandflag lschen*/
  if((spiel.name1.punkte==50)&&(spiel.name2.punkte==40)||
	  (spiel.name1.punkte==40)&&(spiel.name2.punkte==50) )
		spiel.name1.einstand=spiel.name2.einstand=FALSE;

  /* Spiele prfen und Stze zhlen */
  if(spiel.name1.spiele[spiel.satzzahl]>=6)
  {
		switch(spiel.name2.spiele[spiel.satzzahl])
		{
			case 0:
			case 1:
			case 2:
			case 3:
			case 4:
				spiel.satzzahl++;
				spiel.name1.satz++;
			break;
			case 5:
				if(spiel.name1.spiele[spiel.satzzahl]==7)
				{
					spiel.satzzahl++;
					spiel.name1.satz++;
				};
			break;
		};
  };

  if(spiel.name2.spiele[spiel.satzzahl]>=6)
  {
		switch(spiel.name1.spiele[spiel.satzzahl])
		{
			case 0:
			case 1:
			case 2:
			case 3:
			case 4:

				spiel.satzzahl++;
				spiel.name2.satz++;
			break;
			case 5:
				if(spiel.name2.spiele[spiel.satzzahl]==7)
				{
					spiel.satzzahl++;
					spiel.name2.satz++;
				};
			break;
		};
  };


  /* Tiebreak abfangen */
  if((spiel.name1.spiele[spiel.satzzahl]==6)&&(spiel.name2.spiele[spiel.satzzahl]==6))
  {
		a_wechsel();
		spiel.name1.punkte=spiel.name2.punkte=0;
		tiebreak();
  };

  /* Stze kontrollieren */
  if(spiel.spielart==3)
  {
		if(spiel.name1.satz==3)
			gewonnen(spiel.name1.name);
		if(spiel.name2.satz==3)
			gewonnen(spiel.name2.name);
  };

  if(spiel.spielart==2)
  {
		if(spiel.name1.satz==2)
			gewonnen(spiel.name1.name);
		if(spiel.name2.satz==2)
			gewonnen(spiel.name2.name);
  };

};
/*********************************************************
**
** gewonnen()
** =============
** (R) Michael Schrder 03.04.1995
**
**  Ermittelter Gewinner wird ausgegeben
** -> nichts
** <- nichts
**
**********************************************************/
void gewonnen(char name[12])
{
	set_time();
	clrscr();
	gotoxy(1,1);printf("͹TenPro");
	gotoxy(1,8);printf(" RETURN");

	gotoxy(1,2);printf("          Gewonnen in %d Stzen",spiel.name1.satz+spiel.name2.satz);
	gotoxy(1,3);printf("            mit %d Bllen und     ",spiel.baelle);
	gotoxy(1,4);printf("            in %d Minuten hat",spiel.min);
	gotoxy(1,5);printf("               %s    ",name);
	while(getch()!=RET);
	clrscr();
	gotoxy(1,1);printf(" Spielstand vom: %s %s ",d_puf, z_puf);
	gotoxy(1,8);printf(" RETURN");
	gotoxy(2,2);printf("         %s ", spiel.name1.name);
	gotoxy(25,2);printf("%s ",spiel.name2.name);

	for(i=1;i<=spiel.name1.satz+spiel.name2.satz;i++)
	{
		gotoxy(2,2+i);printf(" Satz %d: %d             %d ", i, spiel.name1.spiele[i-1], spiel.name2.spiele[i-1]);
	};
	while(getch()!=RET);
	spiel.ende=TRUE;
	clrscr();
	gotoxy(1,1);printf("͹TenPro");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("  Ergebnis als Textdatei sicher (J/N)");
	c=getch();
	if(c=='J'||c=='j')
		save_spiel(),save=FALSE;
	drucken();
};

/*********************************************************
**
** neu()
** =============
** (R) Michael Schrder 02.04.1995
**
**  Neunes Spiel anfangen
** -> nichts
** <- nichts
**
**********************************************************/
void neu(void)
{
	if(save)
	{
		clrscr();
		gotoxy(2,3);printf("Spielstand wurde noch nicht gesichert");
		gotoxy(2,6);printf("  Altes Spiel jetzt sichern ?(J/N)");
		c=getch();
		if(c=='J'||c=='j')
			save_spiel();
	};

	/* Namen eingeben */
	clrscr();
	gotoxy(1,2);printf("  Bitte Namen des \n  linken Spielers eingeben:");
	gotoxy(5,6);printf("___________");
	gotoxy(5,5);scanf("%s",spiel.name1.name);
	spiel.name1.name[12]=0;
	clrscr();
	gotoxy(1,2);printf("  Bitte Namen des \n  rechten Spielers eingeben:");
	gotoxy(5,6);printf("___________");
	gotoxy(5,5);scanf("%s",spiel.name2.name);
	spiel.name2.name[12]=0;

	/* Spiel angefangen setzen */
	save=TRUE;
	spiel.min=0;

	/* Initialisieren der felder */
	spiel.name1.einstand=spiel.name2.einstand=FALSE;
	spiel.name1.punkte=spiel.name2.punkte=0;
	for(i=0;i<5;i++)
		spiel.name1.spiele[i]=spiel.name2.spiele[i]=0;
	spiel.name1.aufschlag=spiel.name2.aufschlag=FALSE;
	spiel.name1.satz=spiel.name2.satz=0;
	spiel.satzzahl=0;
	spiel.baelle=0;
	a_wechsel();
	init();
	fill();
};
/***************************************************************
**
** T_stat(void)
** =============
** (R) Michael und Martin Schrder 03.04.1995
**
** Statistische Ermittlung der gespielten spiel.baelle und
** Fehler des , der , Spieler
**
** -> Nichts
** <- Nichts
**
****************************************************************/
void t_stat(void)
{
	boolean ende=TRUE;

	clrscr();
	gotoxy(1,1);printf("͹TenPro Trainigsstatistik ");
	gotoxy(1,8);printf("");
	gotoxy(2,2);printf("An(g)riff.:        (V)orhandf   :   ");
	gotoxy(2,3);printf("(D)oppelf.:        (T)opspinf   :   ");
	gotoxy(2,4);printf("(P)assierf:        (N)etzfehl   :   ");
	gotoxy(2,5);printf("(U)eberf. :        (R)ckhandf. :   ");
	gotoxy(2,6);printf("(S)licef. :        (X)Reset         ");
	gotoxy(2,7);printf("(A)sse    :      Gespielte Blle:  ");

	do
	{
		gotoxy(14,2);printf("%d",spiel.g);gotoxy(36,2);printf("%d",spiel.v);
		gotoxy(14,3);printf("%d",spiel.d);gotoxy(36,3);printf("%d",spiel.t);
		gotoxy(14,4);printf("%d",spiel.p);gotoxy(36,4);printf("%d",spiel.n);
		gotoxy(14,5);printf("%d",spiel.u);gotoxy(36,5);printf("%d",spiel.r);
		gotoxy(14,6);printf("%d",spiel.s);
		gotoxy(14,7);printf("%d",spiel.a);gotoxy(36,7);printf("%d ",spiel.b);
		c=getch();
		switch(c)
		{
			case 'g':
			case 'G':
				spiel.g++;
				spiel.b++;
			break;
			case 'd':
			case 'D':
				spiel.d++;
				spiel.b++;
			break;
			case 'p':
			case 'P':
				spiel.p++;
				spiel.b++;
			break;
			case 'u':
			case 'U':
				spiel.u++;
				spiel.b++;
			break;
			case 's':
			case 'S':
				spiel.s++;
				spiel.b++;
			break;
			case 'A':
			case 'a':
				spiel.a++;
				spiel.b++;
			break;
			case 'v':
			case 'V':
				spiel.v++;
				spiel.b++;
			break;
			case 't':
			case 'T':
				spiel.t++;
				spiel.b++;
			break;
			case 'n':
			case 'N':
				spiel.n++;
				spiel.b++;
			break;
			case 'r':
			case 'R':
				spiel.r++;
				spiel.b++;
			break;

			case 32:
				spiel.b++;
			break;

			/* Hilfe anzeigen */
			case 'h':
			case 'H':
				clrscr();
				gotoxy(2,1);printf("Ballstatistik Hilfe          (Seite 1)");
				gotoxy(2,2);printf("Die Ballstatistik ist eine bersicht");
				gotoxy(2,3);printf("ber gngige Fehler in Standartbllen");
				gotoxy(2,4);printf("bei einem Spiel.");
				gotoxy(2,5);printf("So kann man ber die bersicht, spter");
				gotoxy(2,6);printf("mit dem Spieler in Gesprch Fehler er-");
				gotoxy(2,7);printf("kennen und evtl. helfen");
				gotoxy(2,8);printf("Mit beliebiger Taste weiter ...");
				getch();
				clrscr();
				gotoxy(2,1);printf("Ballstatistik Hilfe          (Seite 2)");
				gotoxy(2,2);printf("Die jeweiligen Anfangsbuchstaben ver-");
				gotoxy(2,3);printf("teilen die Punkte auf die Ballarten.");
				gotoxy(2,4);printf("mit RESET erreicht man die Null-");
				gotoxy(2,5);printf("Stellung der Punkte.");
				gotoxy(2,6);printf("Beim Verlassen der Statistikkann man ");
				gotoxy(2,7);printf("die bersicht in einer Textdatei ");
				gotoxy(2,8);printf("Weiter mit beliebiger Taste  ...");
				getch();
				clrscr();
				gotoxy(2,1);printf("Ballstatistik Hilfe          (Seite 3)");
				gotoxy(2,2);printf("ablegen und spter mit einem Textver-");
				gotoxy(2,3);printf("arbeitungsprogramm weiter bearbeiten,");
				gotoxy(2,4);printf("ausdrucken odr archivieren.");
				gotoxy(2,5);printf("So lassen sich ganze Trainigsfort-");
				gotoxy(2,6);printf("Schritte ablegen und beobachten!");
				gotoxy(2,7);printf("  "    );
				gotoxy(2,8);printf("Ende mit beliebiger Taste  ...");
				getch();
				clrscr();
				gotoxy(1,1);printf("͹TenPro Trainigsstatistik ");
				gotoxy(1,8);printf("");
				gotoxy(2,2);printf("An(g)riff.:        (V)orhandf   :   ");
				gotoxy(2,3);printf("(D)oppelf.:        (T)opspinf   :   ");
				gotoxy(2,4);printf("(P)assierf:        (N)etzfehl   :   ");
				gotoxy(2,5);printf("(U)eberf. :        (R)ckhandf. :   ");
				gotoxy(2,6);printf("(S)licef. :        (X)Reset         ");
				gotoxy(2,7);printf("(A)sse    :      Gespielte Blle:  ");
			break; /* Hilfe */
			case 'x':
			case 'X':
				spiel.b=0,spiel.d=0,spiel.p=0,spiel.r=0,spiel.v=0,
				spiel.g=0,spiel.u=0,spiel.t=0,spiel.n=0,spiel.a=0,spiel.s=0;
				clrscr();
				gotoxy(1,1);printf("͹TenPro Trainigsstatistik ");
				gotoxy(2,2);printf("An(g)riff.:        (V)orhandf   :   ");
				gotoxy(2,3);printf("(D)oppelf.:        (T)opspinf   :   ");
				gotoxy(2,4);printf("(P)assierf:        (N)etzfehl   :   ");
				gotoxy(2,5);printf("(U)eberf. :        (R)ckhandf. :   ");
				gotoxy(2,6);printf("(S)licef. :        (X)Reset         ");
				gotoxy(2,7);printf("(A)sse    :      Gespielte Blle:  ");
				gotoxy(1,8);printf("");

			break;
			/* Zeit anzeigen */
			case 'z':
			case 'Z':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(5,3);printf("Heute ist der %s.",d_puf);
				gotoxy(5,6);printf("Es ist %s Uhr.",z_puf);
				getch();
				clrscr();
				gotoxy(1,1);printf("͹TenPro Trainigsstatistik ");
				gotoxy(1,8);printf("");
				gotoxy(2,2);printf("An(g)riff.:        (V)orhandf   :   ");
				gotoxy(2,3);printf("(D)oppelf.:        (T)opspinf   :   ");
				gotoxy(2,4);printf("(P)assierf:        (N)etzfehl   :   ");
				gotoxy(2,5);printf("(U)eberf. :        (R)ckhandf. :   ");
				gotoxy(2,6);printf("(S)licef. :        (X)Reset         ");
				gotoxy(2,7);printf("(A)sse    :      Gespielte Blle:  ");
			break;

			case ESC:
				 clrscr();
				 gotoxy(2,3);printf(" Wollen Sie die Statistik in eine");
				 gotoxy(2,4);printf("    Text Datei sichern oder");
				 gotoxy(2,5);printf("      ausdrucken? (J/N)");
				 c=getch();
				 if(c=='J'||c=='j')
					save_tstat();
				ende=FALSE;
			break;
		};

	}while(ende);
};

/*********************************************************
**
** tiebreak()
** =============
** (R) Michael Schrder 03.04.1995
**
**  Tiebreakspielzhleung
** -> nichts
** <- nichts
**
**********************************************************/
/* Aufschlagwechsel nur in Tiebreak */
void aufschlag(void)
{
	if(spiel.name1.aufschlag)
	{
		spiel.name2.aufschlag=TRUE;
		spiel.name1.aufschlag=FALSE;
	}
	else
	{
		spiel.name1.aufschlag=TRUE;
		spiel.name2.aufschlag=FALSE;
	};
	gotoxy(5,4);printf("Aufschlag:    ");
	gotoxy(25,4);printf("Aufschlag:   ");
};

void tiebreak(void)
{

	int rechts=0,links=0, dummy=0;
	boolean ende=TRUE;
	char dummname[12];

	clrscr();
	gotoxy(2,3);printf("   Tiebreak Zhlung beginnt ...");
	while(getch()!=RET);
	clrscr();
	gotoxy(1,1);printf("͹TenPro͹    Tiebreakzhlung ");
	gotoxy(1,8);printf("");
	gotoxy(1,2); printf( "Links :");
	gotoxy(21,2); printf("Rechts:");
	gotoxy(1,3); printf("Punkte:");
	gotoxy(21,3);printf("Punkte:");
	gotoxy(5,4);printf("Aufschlag:    ");
	gotoxy(25,4);printf("Aufschlag:   ");

	do
	{
nochmal:

		gotoxy(18,1);printf("%d",spiel.min);

		/* Fr Spieler links */
		gotoxy(8,2);printf("%s  ",spiel.name1.name);
		gotoxy(9,3);printf("%d",links);
		gotoxy(16,4);
		if(spiel.name1.aufschlag)
			printf("*");

		/* Fr Spieler rechts*/
		gotoxy(28,2);printf("%s  ",spiel.name2.name);
		gotoxy(29,3);printf("%d",rechts);
		gotoxy(36,4);
		if(spiel.name2.aufschlag)
			printf("*");

		gotoxy(2,8);printf(" Blle: %d ", spiel.baelle);
		gotoxy(20,8);printf(" %d Gewinnstze ",spiel.spielart);

		do
		{
			/* Spiel luft, Zeit messen */
			set_time();
			if(zeit.ti_min!=akut_min)
			{
				spiel.min++;
				gotoxy(18,1);printf("%d",spiel.min);
				akut_min=zeit.ti_min;
			};
		}while(!kbhit());

		c=getch();
		switch(c)
		{
			case LARROW:
				spiel.baelle++;
				links++;
			break;

			case RARROW:
				 spiel.baelle++;
				 rechts++;
			break;

			case ESC:
				clrscr();
				gotoxy(2,3);printf("Tiebreak wirklich abbrechen ?? (J/N)");
				c=getch();
				if(c=='J'||c=='j')
				{
					ende=FALSE;
					rechts=links=0;
				};
			break;

			case 'a':
			case 'A':
				aufschlag();
				goto nochmal;

			case TAB:
				dummy=rechts;
				rechts=links;
				links=dummy;
				dummy=spiel.name1.aufschlag;
				spiel.name1.aufschlag=spiel.name2.aufschlag;
				spiel.name2.aufschlag=(boolean)dummy;
				strcpy(dummname,spiel.name1.name);
				strcpy(spiel.name1.name, spiel.name2.name);
				strcpy(spiel.name2.name, dummname);
				gotoxy(5,4);printf("Aufschlag:    ");
				gotoxy(25,4);printf("Aufschlag:   ");
				goto nochmal;

			/* Zeit anzeigen */
			case 'z':
			case 'Z':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(5,3);printf("Heute ist der %s.",d_puf);
				do
				{
					if(i!=zeit.ti_sec)
					{
						gotoxy(5,6);printf("   Es ist %s Uhr.",z_puf);
						i=zeit.ti_sec;
					};
					set_time();
				}while(!kbhit());
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹    Tiebreakzhlung ");
				gotoxy(1,8);printf("");
				gotoxy(1,2); printf( "Links :");
				gotoxy(21,2); printf("Rechts:");
				gotoxy(1,3); printf("Punkte:");
				gotoxy(21,3);printf("Punkte:");
				gotoxy(5,4);printf("Aufschlag:    ");
				gotoxy(25,4);printf("Aufschlag:   ");

				goto nochmal;

			/* Zeit anzeigen */
			case 'p':
			case 'P':
				set_time();
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹ Version 1.00 ");
				gotoxy(1,8);printf("");
				gotoxy(1,3);printf("      Pausenanfang: %s",z_puf);
				do
				{
					if(i!=zeit.ti_sec)
					{
						gotoxy(5,5);printf("  Aktuelle Zeit %s  ",z_puf);
						i=zeit.ti_sec;
					};
					set_time();
				}while(!kbhit());
				clrscr();
				gotoxy(1,1);printf("͹TenPro͹    Tiebreakzhlung ");
				gotoxy(1,8);printf("");
				gotoxy(1,2); printf( "Links :");
				gotoxy(21,2); printf("Rechts:");
				gotoxy(1,3); printf("Punkte:");
				gotoxy(21,3);printf("Punkte:");
				gotoxy(5,4);printf("Aufschlag:    ");
				gotoxy(25,4);printf("Aufschlag:   ");

				goto nochmal;


			default:
				continue;
		};

		/* Abbruch bei ESC */
		if(!ende)
			break;

		/* Tiebreakbedingungen prfen ... */

		/* Spielende emitteln  */
		 if( ( ((rechts>=6)||(links>=6)) ) && (abs(rechts-links)>=2) )
			ende=FALSE;

		/* Aufschlagwechsel bei ungerade Punkten */
		 if( (rechts+links)%2 )
			aufschlag();

		 /* Seitenwechsel ermitteln */
		 if(!((rechts+links)%6))
		 {
			dummy=rechts;
			rechts=links;
			links=dummy;
			dummy=spiel.name1.aufschlag;
			spiel.name1.aufschlag=spiel.name2.aufschlag;
			spiel.name2.aufschlag=(boolean)dummy;
			strcpy(dummname,spiel.name1.name);
			strcpy(spiel.name1.name, spiel.name2.name);
			strcpy(spiel.name2.name, dummname);
			gotoxy(5,4);printf("Aufschlag:    ");
			gotoxy(25,4);printf("Aufschlag:   ");
		 };

	}while(ende);

	if((!ende)&&(rechts!=0||links!=0))
	{
		if(rechts>links)
		{
			spiel.name2.spiele[spiel.satzzahl]++;
			spiel.satzzahl++;
			spiel.name2.satz++;
		}
		else
		{
			spiel.name1.spiele[spiel.satzzahl]++;
			spiel.satzzahl++;
			spiel.name1.satz++;
		};
		clrscr();
		gotoxy(2,3);printf("   Tiebreak abgeschlossen .........");
		getch();
		init();
		fill();
	}
	else
	{
		clrscr();
		gotoxy(2,3);printf("	Tiebreak wurde abgebrochen! ");
		gotoxy(2,4);printf("     	Spiel ungltig");
		getch();
		undo(0);
		spiel.name1.punkte=spiel.name2.punkte=0;
		init();
		fill();
	};
};
/*********************************************************
**
** undo()
** =============
** (R) Michael Schrder 07.04.1995
**
**  Letzen Spielstand holen
**  -> holen ==0, sicher ==1;
** <- nichts
**
**********************************************************/
void undo(int was)
{

	if(was)
	{
		save1.punkte=spiel.name1.punkte;
		for(i=0;i<6;i++)
			save1.spiele[i]=spiel.name1.spiele[i];
		save1.aufschlag=spiel.name1.aufschlag;
		save1.einstand=spiel.name1.einstand;
		strcpy (save1.name, spiel.name1.name);

		save2.punkte=spiel.name2.punkte;
		for(i=0;i<6;i++)
			save2.spiele[i]=spiel.name2.spiele[i];
		save2.aufschlag=spiel.name2.aufschlag;
		save2.einstand=spiel.name2.einstand;
		strcpy (save2.name, spiel.name2.name);
	}
	else
	{
		spiel.name1.punkte=save1.punkte;
		for(i=0;i<6;i++)
			spiel.name1.spiele[i]=save1.spiele[i];
		spiel.name1.aufschlag=save1.aufschlag;
		spiel.name1.einstand=save1.einstand;
		strcpy (spiel.name1.name, save1.name);

		spiel.name2.punkte=save2.punkte;
		for(i=0;i<6;i++)
			spiel.name2.spiele[i]=save2.spiele[i];
		spiel.name2.aufschlag=save2.aufschlag;
		spiel.name2.einstand=save2.einstand;
		strcpy (spiel.name2.name, save2.name);
	}

};

/*********************************************************
**
** save_spiel()
** =============
** (R) Michael Schrder 02.04.1995
**
** Speichert den Spielstand in eine Datei
**
** -> nichts
** <- nichts
**
**********************************************************/
void save_spiel(void)
{
	char pfad[255], namen[13];
	int fertig,handel,j;

	/* Pfad ermitteln und setzen*/
	strcpy(pfad, "X:\\");
	pfad[0] = 'A' + getdisk();
	getcurdir(0, pfad+3);

	for(i=0;i<500;i++)
		puffer[i]=32;

	/* Namen eingeben, der gesichert werden soll */
	clrscr();
	if(spiel.ende)
		gotoxy(1,1),printf(" Spielergebnis speichern ");
	else
		gotoxy(1,1),printf(" Spielstand speichern ");

	gotoxy(1,8);printf("");
	gotoxy(15,4);printf("________ (Ohne Endung)");
	gotoxy(3,3);printf("Dateinamen: ");scanf("%s",namen);

	fertig=strlen(namen);

	if(fertig<8)
	{
		namen[fertig]='.';
		if(spiel.ende)
		{
			namen[++fertig]='T';
			namen[++fertig]='X';
			namen[++fertig]='T';
		}
		else
		{
			namen[++fertig]='T';
			namen[++fertig]='E';
			namen[++fertig]='N';
		};
		namen[++fertig]=0;
	}
	else
	{
		namen[8]='.';
		if(spiel.ende)
		{
			namen[9]='T';
			namen[10]='X';
			namen[11]='T';
		}
		else
		{
			namen[9]='T';
			namen[10]='E';
			namen[11]='N';
		};
		namen[12]=0;
	};
          
	/* erstes File einlesen*/
	fertig = findfirst(namen,&dateiblock,0|FA_DIREC);

	if(fertig!=-1)
	{
		clrscr();
		if(spiel.ende)
			gotoxy(1,1),printf(" Spielergebnis speichern ");
		else
			gotoxy(1,1),printf(" Spielstand speichern ");
		gotoxy(1,8);printf(" Taste ");
		gotoxy(5,3);printf(" Datei schon vorhanden !");
		gotoxy(5,4);printf(" Datei berschreiben (J/N)?");
		c=getch();
		if(c=='N'||c=='n')
			fertig=FALSE;
		else
			fertig=TRUE;

	}
	else
		fertig=TRUE;

	if(fertig)
	{
		if( (handel=creat(namen,S_IREAD|S_IWRITE))==-1)
		{
			clrscr();
			if(spiel.ende)
				gotoxy(1,1),printf(" Spielergebnis speichern ");
			else
				gotoxy(1,1),printf(" Spielstand speichern ");
			gotoxy(1,8);printf("");
			gotoxy(4,4);printf("  Datei kann nicht gesichert werden");
		}
		else
		{
			if(spiel.ende)
			{
				set_time();

				sprintf(puffer," Spielstand ");
				sprintf(puffer+40,"\n   vom: %s um %s Uhr.",d_puf, z_puf);
				sprintf(puffer+80,"\n\n        %s ",spiel.name1.name);
				sprintf(puffer+105,"%s:", spiel.name2.name);

				j=120;
				for(i=1;i<=spiel.name1.satz+spiel.name2.satz;i++)
				{
				   sprintf(puffer+j,"\n Satz %d: %d             %d", i, spiel.name1.spiele[i-1], spiel.name2.spiele[i-1]);
				   j+=40;
				};
				sprintf(puffer+j,"\n  Das Spiel dauerte ca %d Minuten.",spiel.min);
				j+=40;
				sprintf(puffer+j,"\n\n by TenPro  Ver:1.00 \n\n");
				j+=40;
				if(write(handel, puffer,j)==-1)
				{
					clrscr();
					gotoxy(1,1);printf(" Spielergebnis speichern ");
					gotoxy(1,8);printf("");
					gotoxy(1,4);printf("  Datei kann nicht gesichert werden");
				}
				else
				{
					close (handel);
					save=FALSE;
				};
			}
			else
			{
				if(write(handel, &spiel, sizeof(spiel))==-1)
				{
					clrscr();
					gotoxy(1,1);printf(" Spielstand speichern ");
					gotoxy(1,8);printf("");
					gotoxy(1,4);printf("  Datei kann nicht gesichert werden");
				}
				else
				{
					close (handel);
					save=FALSE;
				};
			};
		};

	};
	init();
	fill();
};

/*********************************************************
**
** load_spiel()
** =============
** (R) Michael Schrder 02.04.1995
**
** ld einen Spielstand aus einer Datei
**
** > nichts
** < nichts
**
**********************************************************/
boolean load_spiel(void)
{
	char pfad[255], namen[13];
	int fertig,handel;

	/* Pfad ermitteln und setzen*/
	strcpy(pfad, "X:\\");
	pfad[0] = 'A' + getdisk();
	getcurdir(0, pfad+3);

	if(save)
	{
		clrscr();
		gotoxy(2,3);printf("Spielstand wurde noch nicht gesichert");
		gotoxy(2,6);printf("  Altes Spiel jetzt sichern ?(J/N)");
		c=getch();
		if(c=='J'||c=='j')
			save_spiel();
	};

	/* Namen eingeben, der gesichert werden soll */
	clrscr();
	gotoxy(1,1);printf(" Spielstand laden ");
	gotoxy(1,8);printf("");
	gotoxy(15,4);printf("________ (Ohne Endung)");
	gotoxy(3,3);printf("Dateinamen: ");scanf("%s",namen);

	fertig=strlen(namen);

	if(fertig<8)
	{
		namen[fertig]='.';
		namen[++fertig]='T';
		namen[++fertig]='E';
		namen[++fertig]='N';
		namen[++fertig]=0;
	}
	else
	{
		namen[8]='.';
		namen[9]='T';
		namen[10]='E';
		namen[11]='N';
		namen[12]=0;
	};

	/* erstes File einlesen*/
	fertig = findfirst(namen,&dateiblock,0|FA_DIREC);

	if(fertig==-1)
	{
		clrscr();
		gotoxy(1,1);printf(" Spielstand laden ");
		gotoxy(1,8);printf(" Taste ");
		gotoxy(5,4);printf(" Datei nicht vorhanden !");
		getch();
	}
	else
	{
		if( (handel=open(namen,O_RDONLY))==-1)
		{
			clrscr();
			gotoxy(1,1);printf(" Spielstand laden ");
			gotoxy(1,8);printf("");
			gotoxy(1,4);printf("  Datei konnte nicht geladen werden!");
			getch();
		}
		else
			if(read(handel, &spiel, sizeof(spiel))==-1)
			{
				clrscr();
				gotoxy(1,1);printf(" Spielstand laden ");
				gotoxy(1,8);printf("");
				gotoxy(1,4);printf("  Datei konnte nicht geladen werden!");
				getch();
			}
			else
			{
				close (handel);
				save=TRUE;
				init();
				fill();
				return(TRUE);
			};
	};
	init();
	fill();
	return(FALSE);
};

/*********************************************************
**
** dir_spiele()
** =============
** (R) Michael Schrder 02.04.1995
**
**  Bringt abgespeicherte Spiele auf den Schrim
**
** > nichts
** < nichts
**
**********************************************************/
void dir_spiele(void)
{
	char pfad[255], auswahl[13];
	int fertig;
	int x=4, y=3;

	/* Pfad ermitteln und setzen*/
	strcpy(auswahl,"*.T*");
	strcpy(pfad, "X:\\");

	pfad[0] = 'A' + getdisk();
	getcurdir(0, pfad+3);

	/* erstes File einlesen*/
	fertig = findfirst(auswahl,&dateiblock,0|FA_DIREC);
	if(fertig<0)
	{
		clrscr();
		gotoxy(5,4);printf(" Keine Spielstnde gespeichert !");
		getch();
	}
	else
	{
		clrscr();
		gotoxy(1,1);printf(" Gesicherte Spielstnde ");
		gotoxy(1,8);printf(" TASTE ");
		gotoxy(1,2);printf("Pfad: %s",pfad);

		while(TRUE)
		{
			gotoxy(x,y);printf("%s",dateiblock.ff_name);
			y++;

			/* lesen */
			fertig = findnext(&dateiblock);

			if(fertig==-1)
				break;

			if(x==22&&y==7)
			{
				getch();
				clrscr();
				gotoxy(1,1);printf(" Gesicherte Spielstnde ");
				gotoxy(1,8);printf(" TASTE ");
				gotoxy(1,2);printf("Pfad: %s",pfad);
				x=4;
				y=3;
			};
			if(y==7)
			{
				if(x==4) x=22; else x=4;
				y=3;
			};

		};
		getch();
	};
};

/********************************************************************
**
** set_time()
** ======
** (R) Michael Schrder 07.05.1995
**
** holt die Uhrzeit und gibt sie in eineb globalen Puffer
**
** --> nichts
** <-- nichts
**
*********************************************************************/
void set_time(void)
{
	gettime(&zeit);
	_strtime(z_puf);
	_strdate(d_puf);
	/*z_puf[9]=0;*/
};
/********************************************************************
**
** save_tstat
** ==========
** (R) Michael Schrder 07.05.1995
**
** sichert die Ballstatistik
**
** --> nichts
** <-- nichts
**
*********************************************************************/
void save_tstat(void)
{
	char pfad[255], namen[13], c, spielername[30];
	int fertig,handel,j,i;

	/* Pfad ermitteln und setzen*/
	strcpy(pfad, "X:\\");
	pfad[0] = 'A' + getdisk();
	getcurdir(0, pfad+3);

	for(i=0;i<500;i++)
		puffer[i]=32;

	/* Namen eingeben */
	clrscr();
	gotoxy(1,1),printf(" Ball Statistik speichern ");
	gotoxy(1,8);printf("");
	gotoxy(1,2);printf("  Bitte Namen des \n  Spielers eingeben:");
	gotoxy(5,6);printf("____________________________");
	gotoxy(5,5);scanf("%s",spielername);
	spielername[30]=0;

	drucken_ballstat(spielername);

	/* Namen eingeben, der gesichert werden soll */
	clrscr();
	gotoxy(1,1),printf(" Ball Statistik speichern ");
	gotoxy(1,8);printf("");
	gotoxy(15,4);printf("________ (Ohne Endung)");
	gotoxy(3,3);printf("Dateinamen: ");scanf("%s",namen);

	fertig=strlen(namen);

	if(fertig<8)
	{
		namen[fertig]='.';
		namen[++fertig]='T';
		namen[++fertig]='X';
		namen[++fertig]='T';
		namen[++fertig]=0;
	}
	else
	{
		namen[8]='.';
		namen[9]='T';
		namen[10]='X';
		namen[11]='T';
		namen[12]=0;
	};

	/* erstes File einlesen*/
	fertig = findfirst(namen,&dateiblock,0|FA_DIREC);

	if(fertig!=-1)
	{
		clrscr();
		gotoxy(1,1),printf(" Ball Statistik speichern ");
		gotoxy(1,8);printf("");
		gotoxy(5,3);printf(" Datei schon vorhanden !");
		gotoxy(5,4);printf(" Datei berschreiben (J/N)?");
		c=getch();
		if(c=='N'||c=='n')
			fertig=FALSE;
		else
			fertig=TRUE;

	}
	else
		fertig=TRUE;

	if(fertig)
	{
		if( (handel=creat(namen,S_IREAD|S_IWRITE))==-1)
		{
			clrscr();
			gotoxy(1,1),printf(" Ball Statistik speichern ");
			gotoxy(1,8);printf("");
			gotoxy(4,4);printf("  Datei kann nicht gesichert werden");
		}
		else
		{
			set_time();
			sprintf(puffer," Ball Statistik ");
			sprintf(puffer+40,"\n   vom: %s um %s Uhr",d_puf, z_puf);
			sprintf(puffer+80,"\n   fr: %s ",spielername);

			sprintf(puffer+120,"\n Angriff. :%d\t Vorhandf. :%d",spiel.g, spiel.v);
			sprintf(puffer+160,"\n Doppelf. :%d\t Topspinf. :%d",spiel.d, spiel.t);
			sprintf(puffer+200,"\n Passierf.:%d\t Netzfehl. :%d",spiel.p, spiel.n);
			sprintf(puffer+240,"\n Ueberf.  :%d\t Rckhandf.:%d",spiel.u, spiel.r);
			sprintf(puffer+280,"\n Slicef.  :%d\t Asse      :%d",spiel.s, spiel.a);
			sprintf(puffer+320  ,"\n\n by TenPro  Ver:1.00 \n\n");

			if(write(handel, puffer,360)==-1)
			{
				clrscr();
				gotoxy(1,1);printf(" Ball Statistik speichern ");
				gotoxy(1,8);printf("");
				gotoxy(1,4);printf("  Datei kann nicht gesichert werden");
			}
			else
			{
				close (handel);
				save=FALSE;
			};
		};

	};
};

/********************************************************************
**
** drucken()
** ==========
** (R) Michael Schrder 08.05.1995
**
** Druckt den Spielstand, bzw das Ergebnis auf den Drucker
** an der Parallen Schnitstelle
**
** --> nichts
** >-- nichts
**
********************************************************************/
boolean drucken(void)
{
	FILE *lptport;

	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("   Soll nun gedruckt werden? (J/N)");
	c=getch();
	if(c=='N'||c=='n')
		return(FALSE);

	/* Druckerzeiger holen zum Ausdrucken */
	lptport=fopen("LPT1", "wb");

	/* wenn Spiel fertig ist */
	if(spiel.ende)
	{
		fprintf(lptport, "\n    Spiel Ergebnises Ausdruck \n\n");
		fprintf(lptport, "\n   Ausdruck des Spielergebnis vom %s um %s Uhr \n",d_puf, z_puf );
		fprintf(lptport, "\n\n\t\t%s gegen\t%s \n ",spiel.name1.name, spiel.name2.name );
		for(i=1;i<=spiel.name1.satz+spiel.name2.satz;i++)
		{
			fprintf(lptport,"\n\tSatz %d:\t%d\t\t%d", i, spiel.name1.spiele[i-1], spiel.name2.spiele[i-1]);
		};
		fprintf(lptport, "\n   Es dauerte %d Minuten \n   und es wurden %d Blle gespielt.",spiel.min, spiel.baelle );
		fprintf(lptport, "\n\n    (R) by TenPro \n");

	}
	else
	{
		fprintf(lptport, "\n    Spiel - Stand Ausdruck \n\n");
		fprintf(lptport, "\n   Ausdruck des Spielstandes vom %s um %s Uhr \n",d_puf, z_puf );
		fprintf(lptport, "\n\n\t\t%s gegen\t%s ",spiel.name1.name, spiel.name2.name );
		for(i=1;i<=spiel.name1.satz+spiel.name2.satz;i++)
		{
			fprintf(lptport,"\n\tSatz %d:\t%d\t\t%d", i, spiel.name1.spiele[i-1], spiel.name2.spiele[i-1]);
		};
		fprintf(lptport, "\n   Es dauerte bisher %d Minuten \n   und es wurden bislang %d Blle gespielt.",spiel.min, spiel.baelle );
		fprintf(lptport, "\n\n    (R) by TenPro \n");

	};
	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("   Daten an den Drucker gesendet...");
	getch();

	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("       Blatt auswerfen ? (J/N)");
	c=getch();
	if(c=='j'||c=='J')
		fprintf(lptport, "\n\f ");

	return(TRUE);
};
/********************************************************************
**
** drucken()
** ==========
** (R) Michael Schrder 08.05.1995
**
** Druckt den Spielstand, bzw das Ergebnis auf den Drucker
** an der Parallen Schnitstelle
**
** --> nichts
** >-- nichts
**
********************************************************************/
boolean drucken_ballstat(char spielername[30])
{
	FILE *lptport;

	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("      Soll die Ball Statistik");
	gotoxy(1,5);printf("      gedruckt werden?  (J/N)");
	c=getch();
	if(c=='N'||c=='n')
		return(FALSE);
	set_time();
	/* Druckerzeiger holen zum Ausdrucken */
	lptport=fopen("LPT1", "wb");

	fprintf(lptport, "\n    Trainigsstatistik Ausdruck \n\n");
	fprintf(lptport, "\n   Ausdruck des Trainigsergebnisses vom %s um %s Uhr \n",d_puf, z_puf );
	fprintf(lptport, "\n\n    fr %s\n",spielername);
	fprintf(lptport, "\n    Angriff. :%d  \t Vorhandf. :%d",spiel.g, spiel.v);
	fprintf(lptport, "\n    Doppelf. :%d  \t Topspinf. :%d",spiel.d, spiel.t);
	fprintf(lptport, "\n    Passierf.:%d  \t Netzfehl. :%d",spiel.p, spiel.n);
	fprintf(lptport, "\n    berkopf.:%d  \t Rckhandf.:%d",spiel.u, spiel.r);
	fprintf(lptport, "\n    Slicef.  :%d  \t Asse      :%d",spiel.s, spiel.a);
	fprintf(lptport, "\n\n    Gesammt gespielte Blle  :%d",spiel.b);
	fprintf(lptport, "\n\n    by TenPro  Ver:1.00 \n\n");

	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("   Daten an den Drucker gesendet...");
	getch();

	clrscr();
	gotoxy(1,1),printf(" Ausdruck ");
	gotoxy(1,8);printf("");
	gotoxy(1,4);printf("       Blatt auswerfen ? (J/N)");
	c=getch();
	if(c=='j'||c=='J')
		fprintf(lptport, "\n\f ");

	return(TRUE);
};
