#ifndef DLLGLOB_H
#define DLLGLOB_H

/* ****************************************************************************************
*                    DOSDLL - Dynamic Libraries for old MS-DOS
*   (c) 2007 by R.-Erik Ebert  -  ebert@kiezsoft.de
*   - Some ideas were borrowed from MikDLL (c) 1995 by Jean-Paul Mikkers (MikMak). -
*  This library is FREEWARE and provided without any kind of warrenty.
  *****************************************************************************************/


/** \file
Compiler dependent definitions for transfer of global variables.
Runtime liraries of most compilers use some globally defined variables
to be initialzed by startup code of program. Because startup code is not
executed modules loaded dynamically at runtime, initialization have to be done
by their entry point function to make using of runtime libraries inside module possible.
@par This file provides a structure for transfer needed variables
of Turbo C++-compilers and two macros to fill and read from this structure.
For other compilers the structure and the macros are defined too, but
they are only dummies.
@see DLLGLOBSTRUCT, _fillDllGlobStruct, _applyDllGlobStruct
*/

/** @name Memory and process helper functions.
<p>Most C/C++ compilers (including Turbo-/Borland-C/C++) use their own memory management
routines for (far)malloc/calloc functions in runtime library. These routines modify
some internal variables in order to manage the heap. Using of memory allocation functions
inside a dynamic library would confuse memory management of main program, i.e. one must
not use them. Furthermore it is not a good idea to use calls to DOS memory allocation functions
inside a dynamix library too. Allocation of memory blocks via DOS calls may prevent main program
from enlarging its heap if needed.</p>
<p>In order to provide a save way for (de)allocating memory in a DLL DOS-DLL library implements
its own functions and exports it to each dynamic library.</p>
 */
//@{

/** Type of memory allocation function.
Function makes a call to <tt>farmalloc</tt> on the main programs side. The implementation can be found
in usedll.cpp. Inside a dynamic library name of the allocation function is "GetMem".
@param size size of memory to allocate in bytes
@return far pointer to allocated memory block on success, otherwise NULL
@see _GetMem, GetMem
*/
typedef void far* huge (*GetMemFunc)(unsigned long size);

/** Type of memory deallocation function.
Function makes a call to <tt>farfree</tt> on the main programs side. The implementation can be found
in usedll.cpp. Inside a dynamic library name of the deallocation function is "FreeMem".
@param block pointer to memory block to deallocate
@see _FreeMem, FreeMem
*/
typedef void huge (*FreeMemFunc)(void far* block);

/** Type of spawn function.
Because spawn/exec functions of runtime library make use of memory allocation functions there is the same
problem as for malloc/free functions. Thats why DOS-DLL library provides provides its own spawn function
too. The implementation can be found in usedll.cpp. Internally it makes use of
spawnlp library function on the main programs side. Inside a dynamic library name of the execution function
is "Spawn".
@param cmd Name of program to execute (may contain a path and an extension). Location of programs
is done according program search rules of MS-DOS.
@param args string containing argument so pass to program call
@return return code of program execution or -1 on invalid argument.
@see _Spawn, Spawn
*/
typedef int huge (*SpawnFunc)(char far* cmd, char far* args);

/** Declaration of GetMem function pointer.
Definition of this variable in a dynamic library is done by #END_EXPTABLE macro and assignment
by #IMPLEMENT_DEFAULT_ENTRYFUNC or #IMPLEMENT_DEFAULT_ENTRYFUNC_ENV macros.
@note If you don't use these macros you will need to do definition and assignment manually
in DLL implementation. The function pointer is transfered in #DLLGLOBSTRUCT structure to
entry point function.
*/
extern GetMemFunc GetMem;

/** Declaration of FreeMem function pointer.
Definition of this variable in a dynamic library is done by #END_EXPTABLE macro and assignment
by #IMPLEMENT_DEFAULT_ENTRYFUNC or #IMPLEMENT_DEFAULT_ENTRYFUNC_ENV macros.
@note If you don't use these macros you will need to do definition and assignment manually
in DLL implementation. The function pointer is transfered in #DLLGLOBSTRUCT structure to
entry point function.
*/
extern FreeMemFunc FreeMem;

/** Declaration of Spawn function pointer.
Definition of this variable in a dynamic library is done by #END_EXPTABLE macro and assignment
by #IMPLEMENT_DEFAULT_ENTRYFUNC or #IMPLEMENT_DEFAULT_ENTRYFUNC_ENV macros.
@note If you don't use these macros you will need to do definition and assignment manually
in DLL implementation. The function pointer is transfered in #DLLGLOBSTRUCT structure to
entry point function.
*/
extern SpawnFunc Spawn;
//@}

#ifdef __TURBOC__

#if !defined(_Cdecl)
	#if __STDC__
	#define _Cdecl
	#else
	#define _Cdecl  cdecl
	#endif
#endif



#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

/* Define _NOFLOAT_ symbol if you need not any floating point types nor operations.
   Note that _NOFLOAT_ must be defined if compiler option for floating
   point support is set to "None". */
#ifndef _NOFLOAT_
  #include <float.h>
#endif

#include <dos.h>

/*;                       Interrupt vector save areas
;
;       Interrupt vectors 0,4,5 & 6 are saved at startup and then restored
;       when the program terminates.  The signal/raise functions might
;       steal these vectors during execution.
;
;       Note: These vectors save area must not be altered
;             without changing the save/restore logic.
;
PubSym@         _Int0Vector     <dd     0>,             __CDECL__
PubSym@         _Int4Vector     <dd     0>,             __CDECL__
PubSym@         _Int5Vector     <dd     0>,             __CDECL__
PubSym@         _Int6Vector     <dd     0>,             __CDECL__ */


extern void far*  _Cdecl _Int0Vector;
extern void far*  _Cdecl _Int4Vector;
extern void far* _Cdecl _Int5Vector;
extern void far* _Cdecl _Int6Vector;

/*;
;                       Miscellaneous variables
;
PubSym@         _C0argc,        <dw     0>,             __CDECL__
dPtrPub@        _C0argv,        0,                      __CDECL__
dPtrPub@        _C0environ,     0,                      __CDECL__
PubSym@         _envLng,        <dw     0>,             __CDECL__
PubSym@         _envseg,        <dw     0>,             __CDECL__
PubSym@         _envSize,       <dw     0>,             __CDECL__
PubSym@         _psp,           <dw     0>,             __CDECL__
PubSym@         _version,       <label word>,           __CDECL__
PubSym@         _osversion,     <label word>,           __CDECL__
PubSym@         _osmajor,       <db     0>,             __CDECL__
PubSym@         _osminor,       <db     0>,             __CDECL__
PubSym@         errno,          <dw     0>,             __CDECL__
PubSym@         _StartTime,     <dw   0,0>,             __CDECL__
*/

extern int _Cdecl _C0argc;
extern char far* far *_Cdecl _C0argv;
extern char far* far* _Cdecl _C0environ;
extern unsigned _Cdecl _envLng;
extern unsigned _Cdecl _envseg;
extern unsigned _Cdecl _envSize;
extern unsigned _Cdecl _psp;

extern unsigned _Cdecl  _version;
extern int _Cdecl errno;
extern unsigned long _Cdecl _StartTime;
extern char** environ;

/*
;       Memory management variables

IF      LDATA  EQ  false
PubSym@         __heapbase,     <dw   DGROUP:edata@>,   __CDECL__
ENDIF
IFNDEF __HUGE__
PubSym@         __brklvl,       <dw   DGROUP:edata@>,   __CDECL__
ENDIF
PubSym@         _heapbase,      <dd   0>,       __CDECL__
PubSym@         _brklvl,        <dd   0>,       __CDECL__
PubSym@         _heaptop,       <dd   0>,       __CDECL__ */

extern void far* _Cdecl _heapbase;
extern void far* _Cdecl _brklvl;
extern void far* _Cdecl _heaptop;

extern  unsigned      _Cdecl _heaplen;
extern  unsigned      _Cdecl _stklen;
extern  unsigned      _Cdecl _fpstklen;


#ifndef _NOFLOAT_
  extern  const int _Cdecl _8087;
#endif


/** Internal transfer structure for global variables.
This structure is used to transfer values of globally defined
variables of main program to dynamic libraries. It depends
on compiler used. This structure works for Borland compilers from
Turbo-C++ 1.01 to Borland C++ 3.1.
*/
typedef struct _DLLGLOBSTRUCT
{
    GetMemFunc GetMem;
    FreeMemFunc FreeMem;
    SpawnFunc Spawn;
	void far*  _Int0Vector;
	void far*  _Int4Vector;
	void far*  _Int5Vector;
	void far*  _Int6Vector;
	int  _C0argc;
	char far* far*  _C0argv;
	char far* far*  _C0environ;
	unsigned  _envLng;
	unsigned  _envseg;
	unsigned  _envSize;
	unsigned  _psp;

	unsigned   _version;
	int  errno;
	unsigned long  _StartTime;
  //  void far* penviron;
	void far*  _heapbase;
	void far*  _brklvl;
	void far*  _heaptop;
	unsigned _heaplen;
	unsigned _stklen;
	unsigned _fpstklen;
	int _8087;
	// variables from float.h
	unsigned int _default87;

#ifndef _NOFLOAT_
	float _huge_flt;
	double _huge_dble;
	long double _huge_ldble;
	long double _tiny_ldble;
#else
	long _huge_flt;
	char _huge_dble[8];
	char _huge_ldble[10];
	char _tiny_ldble[10];
#endif
}  DLLGLOBSTRUCT;


#ifndef _NOFLOAT_
   #define _fillFloatVars(STR) { \
      (*STR)._8087=_8087; \
	  (*STR)._default87=_default87; \
	  (*STR)._huge_flt=_huge_flt; \
	  (*STR)._huge_dble=_huge_dble; \
	  (*STR)._huge_ldble=_huge_ldble; \
	  (*STR)._tiny_ldble=_tiny_ldble; \
   }
   #define _applyFloatVars(STR) { \
      ((int)_8087)=(*STR)._8087; \
	  _default87=(*STR)._default87; \
	  _huge_flt=(*STR)._huge_flt; \
	  _huge_dble=(*STR)._huge_dble; \
	  _huge_ldble=(*STR)._huge_ldble; \
	  _tiny_ldble=(*STR)._tiny_ldble; \
   }
#else
   #define _fillFloatVars(STR)
   #define _applyFloatVars(STR)
#endif

/** Macro copies global values of global variables to transfer structure.
@see DLLGLOBSTRUCT
*/
#define _fillDllGlobStruct(STR) {\
  (*STR)._Int0Vector=_Int0Vector; \
  (*STR)._Int0Vector=_Int4Vector; \
  (*STR)._Int0Vector=_Int5Vector; \
  (*STR)._Int0Vector=_Int6Vector; \
  (*STR)._C0argc=_C0argc; \
  (*STR)._C0environ=_C0environ; \
  (*STR)._envLng=_envLng; \
  (*STR)._envseg=_envseg; \
  (*STR)._envSize=_envSize; \
  (*STR)._psp=_psp; \
  (*STR)._version=_version; \
  (*STR).errno=errno; \
  (*STR)._StartTime=_StartTime; \
  (*STR)._heapbase=_heapbase; \
  (*STR)._brklvl=_brklvl; \
  (*STR)._heaptop=_heaptop; \
  (*STR)._heaplen=_heaplen;\
  (*STR)._stklen=_stklen;\
  (*STR)._fpstklen=_fpstklen;\
  (*STR).GetMem=_GetMem;\
  (*STR).FreeMem=_FreeMem;\
  (*STR).Spawn=_Spawn;\
  _fillFloatVars(STR) \
}

/** Macros copies values from transfer structure to global variables of dynamic library.
@see DLLGLOBSTRUCT
*/
#define _applyDllGlobStruct(STR) {\
  _Int0Vector=(*STR)._Int0Vector; \
  _Int0Vector=(*STR)._Int4Vector; \
  _Int0Vector=(*STR)._Int5Vector; \
  _Int0Vector=(*STR)._Int6Vector; \
  _C0argc=(*STR)._C0argc; \
  _C0environ=(*STR)._C0environ; \
  _envLng=(*STR)._envLng; \
  _envseg=(*STR)._envseg; \
  _envSize=(*STR)._envSize; \
  _psp=(*STR)._psp; \
  _version=(*STR)._version; \
  errno=(*STR).errno; \
  _StartTime=(*STR)._StartTime; \
  _heapbase=(*STR)._heapbase; \
  _brklvl=(*STR)._brklvl; \
  _heaptop=(*STR)._heaptop; \
  _heaplen=(*STR)._heaplen;\
  _stklen=(*STR)._stklen;\
  _fpstklen=(*STR)._fpstklen;\
  GetMem=(*STR).GetMem;\
  FreeMem=(*STR).FreeMem;\
  Spawn=(*STR).Spawn;\
  _applyFloatVars(STR) \
}

/* Digital Mars support definitions commented out because
  environ = (char**) (*STR).penviron;\
  (*STR).penviron=MK_FP(FP_SEG(environ),FP_OFF(environ));\
  incomplete or incorrect. */
/* #elif __DMC__

#include <stdlib.h>
#include <dos.h>
#ifndef _NOFLOAT_
#include <float.h>
#endif

typedef struct _DLLGLOBSTRUCT
{
    int errno;
    int _doserrno;
    int sys_nerr;
    char ** sys_errlist;
    char __far * _pgmptr;
    unsigned int _osver;
    unsigned short _psp;
    unsigned char _osmajor;
    unsigned char _osminor;
    int __argc;
    char ** __argv;
    unsigned char _osmode;
    unsigned char _cpumode;
    int _fmode;
    char * _envptr;
    char ** _environ;
    unsigned _stack;
    unsigned _osversion;
    unsigned short _exe_type;
    int _8087;
}  DLLGLOBSTRUCT;


#ifndef _NOFLOAT_
   #define _fillFloatVars(STR) { \
      (*STR)._8087=_8087; \
   }
   #define _applyFloatVars(STR) { \
      _8087=(*STR)._8087; \
   }
#else
   #define _fillFloatVars(STR)
   #define _applyFloatVars(STR)
#endif


#define _fillDllGlobStruct(STR) {\
  (*STR).errno=errno; \
  (*STR)._doserrno=_doserrno; \
  (*STR).sys_nerr=sys_nerr; \
  (*STR).sys_errlist=sys_errlist; \
  (*STR)._pgmptr=_pgmptr; \
  (*STR)._osver=_osver; \
  (*STR)._psp=_psp; \
  (*STR)._osmajor=_osmajor; \
  (*STR)._osminor=_osminor; \
  (*STR).__argc=__argc; \
  (*STR).__argv=__argv; \
  (*STR)._osmode=_osmode; \
  (*STR)._cpumode=_cpumode; \
  (*STR)._fmode=_fmode; \
  (*STR)._envptr=_envptr; \
  (*STR)._environ=_environ; \
  (*STR)._stack=_stack; \
  (*STR)._osversion=_osversion; \
  (*STR)._exe_type=_exe_type; \
  _fillFloatVars(STR) \
}

#define _applyDllGlobStruct(STR) {\
  errno=(*STR).errno; \
  _doserrno=(*STR)._doserrno; \
  sys_nerr=(*STR).sys_nerr; \
  ((char**&)sys_errlist)=(*STR).sys_errlist; \
  _pgmptr=(*STR)._pgmptr; \
  _osver=(*STR)._osver; \
  _psp=(*STR)._psp; \
  _osmajor=(*STR)._osmajor; \
  _osminor=(*STR)._osminor; \
  __argc=(*STR).__argc; \
  __argv=(*STR).__argv; \
  _osmode=(*STR)._osmode; \
  _cpumode=(*STR)._cpumode; \
  _fmode=(*STR)._fmode; \
  _envptr=(*STR)._envptr; \
  _environ=(*STR)._environ; \
  _stack=(*STR)._stack; \
  _osversion=(*STR)._osversion; \
  _exe_type=(*STR)._exe_type; \
  _applyFloatVars(STR) \
}
*/
#else // !__TURBOC__ && !__DMC__

/* Dummies for other (unsupported) compilers */

typedef far struct _DLLGLOBSTRUCT
{
    GetMemFunc GetMem;
    FreeMemFunc FreeMem;
    SpawnFunc Spawn;
}  DLLGLOBSTRUCT;
#define _fillDllGlobStruct(STR) {\
  (*STR).GetMem=_GetMem;\
  (*STR).FreeMem=_FreeMem;\
  (*STR).Spawn=_Spawn;\
}

#define _applyDllGlobStruct(STR) {\
  GetMem=(*STR).GetMem;\
  FreeMem=(*STR).FreeMem;\
  Spawn=(*STR).Spawn;\
}
#endif

#endif // !DLLGLOB_H
