#ifndef DOSDLL_H
#define DOSDLL_H

/* ****************************************************************************************
*                    DOSDLL - Dynamic Libraries for old MS-DOS
*   (c) 2007 by R.-Erik Ebert  -  ebert@kiezsoft.de
*   - Some ideas were borrowed from MikDLL (c) 1995 by Jean-Paul Mikkers (MikMak). -
*  This library is FREEWARE and provided without any kind of warrenty.
  *****************************************************************************************/

/** \file
                            DOSDLL.H

  Use this header in your dynamic library implementation.


  A dynamic library should be implemented as in followimg example: It needs not to be linked
  against any additional library.

@code
  #include <stdio.h>
  #include "dosdll.h"

  void huge sayHello()
  {
  	printf("Hello from testdll!\n");
  }

  void huge sayHello1(const char* name)
  {
  	printf("Hello from testdll to %s!\n",name);
  }

  BEGIN_EXPTABLE
     EXPENTRY(sayHello),
     EXPENTRY2("sayHello(const char*)",sayHello1)
  END_EXPTABLE

  IMPLEMENT_DEFAULT_ENTRYFUNC

  REGISTERENTRYFUNC

  int main(int argc, char* argv[])
  {
  	printf("Can't run standalone.\n");
  	return -1;
  }
@endcode
Please note that macros (see above) MUST be noted in this order.
*/

#ifdef __DMC__
      #define huge
#endif

#include <dllglob.h>

#ifdef __cplusplus
extern "C" {
#endif
/** Type of pointer to exported data data or function. */
typedef  void huge* PEXPVAL;

/** Mode type for entry point function.
	The entry point function of dynamic library is called whenever application code calls
	LoadLibrary or FreeLibrary function. In case of LoadLibrary call mode type passed to
	entry point function is <tt>DllModeLoad</tt> on first call (i.e. immediately after loading
	library into memory). For following calls mode type is <tt>DllModeAddRef</tt>.<br>
	If client code invokes FreeLibrary function, entri point function of library is called
	with mode <tt>DllUnload</tt> if last reference to library was released (i.e. before unloading
	from memory) and with mode <tt>DllModeRelease</tt> if there are more references to library.
@see LoadLibrary, FreeLibrary, DllEntryFunc
*/
typedef enum
{
	DllModeLoad = 0,
	DllModeAddRef,
	DllModeRelease,
	DllModeUnload
} DllEntryMode;

/** Type definition of entry point function.
Each module (i.e. dynamic library) needs an entry point function to be called from Dll-loader on adding
references to library or removing from.
@param mode call mode
@param pGlobals pointer to structure of compiler dependent global variables
@note Main purpose of entry point function is initialization of internal registration structure of
type DllRegStruct. In most cases entrx point function will only need to do this initialization
during its first invocation, i.e. in mode <tt>DllModeLoad</tt>. Therefore a macro
#IMPLEMENT_DEFAULT_ENTRYFUNC is defined to do its complete implementation.
@see DllRegStruct, IMPLEMENT_DEFAULT_ENTRYFUNC
*/
typedef void huge (*DllEntryFunc)(DllEntryMode mode, DLLGLOBSTRUCT far* pGlobals);



/** Descriptor structure of a single entry exported from dynamic library.
Each dynamic library has a table containing descriptors of this type for each entry
exported from. Descriptor itselfs simply consists of a name (used as identifier) and a pointer to
entry to export. */
typedef struct _DllExpEntry
{
	/** external name (identifier) of entry */
	const char huge* name;
	/** pointer to the entry, i.e. its address */
	PEXPVAL pFunc;
} DllExpEntry;


/** Internal tag, used from loader to find registration structure. */
#define DLLREGTAG "D_O_S_L_I_B"
/* simply an array initializer */
#define DLLREGTAG0 {'D','_','O','_','S','_','L','_','I','_','B','0'}
/** Size of internal tag, */
#define DLLREGTAGSIZE 11


/** Type of dynamic library registration structure */
typedef struct _DllRegStruct
{
	/** Tag needed to search for entry point on loading. */
	char _regTag[DLLREGTAGSIZE+1];
	/** Entry point function */
	DllEntryFunc pEntryFunc;
	/** Array of exported entries (functions or data) */
	struct _DllExpEntry huge* entryArray;
	/** size of entryArray */
	unsigned entryCount;
} DLLRegStruct;

/** start macro of exports table */
#define BEGIN_EXPTABLE \
   struct _DllRegStruct * _getDllRegStruct(); \
   struct _DllExpEntry _fTable[] = {

/** simple exported entry registration macro */
#define EXPENTRY(NAME) {#NAME, (PEXPVAL) &NAME }
/** marco for export registration using custom export name */
#define EXPENTRY2(EXPNAME,NAME) {EXPNAME, (PEXPVAL) &NAME }

/** end of export table */
#define END_EXPTABLE }; \
   unsigned _fTableSize = sizeof(_fTable) / sizeof(DllExpEntry);\
   GetMemFunc GetMem=0; \
   FreeMemFunc FreeMem=0;\
   SpawnFunc Spawn=0;


/** Default implementation macro for entry point function __DllEntry.
Use this macro if no further initializations to be done after loading,
i.e. in most cases.
*/
#define IMPLEMENT_DEFAULT_ENTRYFUNC \
  void huge __DllEntry(DllEntryMode mode, DLLGLOBSTRUCT far* pGlobals) {\
     switch (mode) {\
       case DllModeLoad:\
        _getDllRegStruct()->entryArray = _fTable;\
        _getDllRegStruct()->entryCount = _fTableSize;\
        if (pGlobals) _applyDllGlobStruct(pGlobals);\
        break;\
       default:\
          break;\
     }\
  }


#ifdef __TURBOC__

/** Extended default implementation macro for entry point function __DllEntry.
This version includes creation and release of environ variable.
Use this macro if no further initializations to be done after loading but
access to environment variables needed by C/C++ runtime functions.
@note This macro is available in Turbo-/Borland-C/C++ builds only.
*/
#define IMPLEMENT_DEFAULT_ENTRYFUNC_ENV \
  void huge __DllEntry(DllEntryMode mode, DLLGLOBSTRUCT far* pGlobals) {\
     char *penv, *p;\
     int i,n;\
     unsigned eseg;\
     switch (mode) {\
       case DllModeLoad:\
        _getDllRegStruct()->entryArray = _fTable;\
        _getDllRegStruct()->entryCount = _fTableSize;\
        if (pGlobals) _applyDllGlobStruct(pGlobals);\
        penv = (char*) MK_FP(_envseg,0);\
        p = penv;\
        n=0;\
        while (*p != 0) {\
          n++;\
          p+= (strlen(p)+1);\
        }\
        environ = (char**)GetMem(n*sizeof(char*));\
        if (environ == 0) return;\
        i=0;\
        p=penv; \
        while (i<n) { \
          environ[i] = p;\
          i++;\
          p+= (strlen(p)+1);\
        }\
        break;\
       case DllModeUnload:\
        if (environ != 0) {\
           FreeMem(environ); \
           environ = 0;\
        }\
        break;\
       default:\
          break;\
     }\
  }
#else
#define IMPLEMENT_DEFAULT_ENTRYFUNC_ENV IMPLEMENT_DEFAULT_ENTRYFUNC
#endif




/** Macro for initialization of registration struct and entry point function */
#define REGISTERENTRYFUNC \
	struct _DllRegStruct _dllRegStruct = {DLLREGTAG0,&__DllEntry,_fTable,_fTableSize}; \
   struct _DllRegStruct* _getDllRegStruct() { return &_dllRegStruct; }

#ifdef __cplusplus
}
#endif
#endif // !DOSDLL_H
