/* ****************************************************************************************
*                    DOSDLL - Dynamic Libraries for old MS-DOS
*   (c) 2007 by R.-Erik Ebert  -  ebert@kiezsoft.de
*   - Some ideas were borrowed from MikDLL (c) 1995 by Jean-Paul Mikkers (MikMak). -
*  This library is FREEWARE and provided without any kind of warrenty.
  *****************************************************************************************/



#include <dir.h>
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <dos.h>
#include <process.h>

#include "usedll.h"
#include "dosdll.h"

/// root of Dll-entry list
static DllEntry* _first = 0;


/** Implementation of exported memory allocation function.
Function simply calls <tt>farmalloc</tt>.
@param size size of memory to allocate in bytes
@return far pointer to allocated memory block on success, otherwise NULL
@see GetMem, GetMemFunc
*/
void far* huge _GetMem(unsigned long size)
{
	return farmalloc(size);
}

/** Implementation of exported memory deallocation function.
Function simply calls <tt>farfree</tt>.
@param block pointer to memory block to deallocate
@see FreeMem, FreeMemFunc
*/
void huge _FreeMem(void far* block)
{
	farfree(block);
}

/** Implementation of exported spawn function.
@param cmd Name of program to execute (may contain a path and an extension). Location of programs
is done according program search rules of MS-DOS.
@param args string containing argument so pass to program call
@return return code of program execution or -1 on invalid argument.
@see _Spawn, SpawnFunc
*/
int huge _Spawn(char far* cmd, char far* args)
{
	if ((cmd==0) || (args == 0)) return -1;
	char far* p;
	unsigned l1,l2;
	for (p=cmd,l1=1;*p != 0;p++) l1++;
	for (p=args,l2=1;*p != 0;p++) l2++;
	char* pcmd= (char*)malloc(l1);
	movedata(FP_SEG(cmd),FP_OFF(cmd),FP_SEG(pcmd),FP_OFF(pcmd),l1);
	char* pargs=(char*)malloc(l2);
	movedata(FP_SEG(args),FP_OFF(args),FP_SEG(pargs),FP_OFF(pargs),l2);
	int result = spawnlp(P_WAIT,pcmd,pargs,pargs,NULL);
	free(pargs);
	free(pcmd);
	return result;
}


/// last error occured
static DllErrState _lastError = DES_OK;

typedef unsigned short UWORD;

/// structure of a DOS EXE-header
typedef struct
{
	char  signature[2];
	UWORD partpag;
	UWORD pagecnt;
	UWORD relocnt;
	UWORD hdrsize;
	UWORD minmem;
	UWORD maxmem;
	UWORD reloss;
	UWORD exesp;
	UWORD chksum;
	UWORD exeip;
	UWORD relocs;
	UWORD tabloff;
	UWORD overlay;
} EXEHEADER;

/** Internal helper class for a single Dll entry.
This class stores information about loaded module and provides
some helper functions for initialization and deinitialization.
@note DllEntry is declared as a struct to make usedll.h header
compatible for using in plain C.
*/
struct DllEntry
{
public:
	char* dllPath;         ///< full library path
	unsigned long modSize; ///< size of module
	void * pMem;            ///< pointer to memory block
	void * pModule;         ///< pointer to startof module
	DLLRegStruct * pRegStruct;   ///< address of modules registration structure
	int refCnt;       ///< reference counter
	DllEntry* pNext;       ///< pointer to next list entry

    /// Ctor - simply initializes all members to zero
	DllEntry() : dllPath(0), modSize(0), pMem(0), pModule(0), pRegStruct(0), refCnt(0), pNext(0)
	{
	}

    /** Dtor.
    The destructor frees memory reserved for module and file-path to it.
    */
	~DllEntry()
	{
		if (pMem) farfree(pMem);
		if (dllPath) free(dllPath);
		if (pNext != 0)
		{
			if (pRegStruct != 0)
  		       pNext->pRegStruct->pEntryFunc(DllModeUnload,0);
		   delete (pNext);
	    }
	}

    /// Release current module.
	int release();

    /// Create (i.e. load and initialize) module from specified path.
	int create(const char* fullpath);
private:
    /// Helper for load module using overlay mechanism.
    int loadOverlay();
    /// Helper for finding entry point of module.
    int findEntryPoint();
};

#ifndef DOXY
struct CleanHelper
{
	~CleanHelper()
	{
		if (_first != 0)
		{
			delete _first;
			_first = 0;
		}
	}
};
static CleanHelper _cleanHelper;
#endif

int DllEntry::create(const char* fullpath)
{
	if (fullpath == 0)
	{
		_lastError = DES_INVALID_ARG;
		return 0;
	}

    dllPath = strdup(fullpath);

	FILE *fp;
	if((fp=fopen(dllPath,"rb"))==NULL)
	{
	   _lastError = DES_ERR_FOPEN;
	   return 0;
	}

  	EXEHEADER hdr;
	if (!fread(&hdr,sizeof(EXEHEADER),1,fp))
	{
		_lastError = DES_ERR_FREAD;
		fclose(fp);
		return 0;
	}
	fclose(fp);

	modSize = (512L*hdr.pagecnt)-(16L*hdr.hdrsize);

   // allocate memory for overlay

    if((pMem=farmalloc(modSize+16))==NULL)
    {
		_lastError = DES_NO_MEMORY;
		return 0;
	}

	// paragraph align module ptr

	pModule=MK_FP(FP_SEG(pMem)+1,0);

	if (!loadOverlay()) return 0;
	if (!findEntryPoint()) return 0;
	DLLGLOBSTRUCT globals;
	_fillDllGlobStruct(&globals);
	// call entry point function
	 pRegStruct->pEntryFunc(DllModeLoad,(DLLGLOBSTRUCT far*) &globals/*(DLLGLOBSTRUCT far*)MK_FP(FP_SEG(&globals),FP_OFF(&globals))*/);
	// insert into list
	pNext = _first;
	_first = this;
	refCnt = 1;
	return 1;
}

int DllEntry::loadOverlay()
{
	union REGS regs;
	struct SREGS sregs;

	struct{
		int envseg;
		int reloc;
	} e;

	// fill segment registers

	segread(&sregs);

	e.envseg=FP_SEG(pModule);
	e.reloc=FP_SEG(pModule);

	regs.h.ah=0x4b;		// dos function 'EXEC'
	regs.h.al=0x03;		// load overlay
	sregs.ds=FP_SEG(dllPath);
	regs.x.dx=FP_OFF(dllPath);

	sregs.es=FP_SEG(&e);
	regs.x.bx=FP_OFF(&e);

	intdosx(&regs,&regs,&sregs);

	if(regs.x.cflag!=0)
	{
		_lastError=DES_ERR_LOADOVL;
		return 0;
	}
    return 1;
}

int DllEntry::findEntryPoint()
{
	unsigned long t;
	char *s= (char *) pModule;

	for(t=0;t<modSize;t++)
	{
		if((!memcmp(s,DLLREGTAG,DLLREGTAGSIZE)) && (s[DLLREGTAGSIZE]=='0'))
		{
			pRegStruct = (DLLRegStruct *) s;
			return 1;
		}
		s++;
	}
	_lastError = DES_NO_ENTRYPOINT;
	return NULL;
}


DllEntry::release()
{
	--refCnt;
	if (refCnt > 0)
	{
		pRegStruct->pEntryFunc(DllModeRelease,0);
		return refCnt;
	}
	pRegStruct->pEntryFunc(DllModeUnload,0);
	if (_first == this)
	{
		_first = pNext;
	}
	else
	{
		for (DllEntry* p = _first;p != 0; p=p->pNext)
		{
			if (p->pNext == this)
			{
				p->pNext = pNext;
				break;
			}
		}
	}
	pNext = 0;
	delete this;
	return 0;
}

static HDLL _findLibrary(const char* fullpath)
{
	for (HDLL p=_first;p != 0; p=p->pNext)
	{

		if (stricmp(fullpath,p->dllPath) == 0)
		   return p;
	}
	return 0;
}

HDLL LoadLibrary(const char* lpFileName)
{
	if (lpFileName == 0)
	{
		_lastError = DES_INVALID_ARG;
		return 0;
	}
	const char* fullpath = searchpath(lpFileName);
	if (fullpath == 0)
	{
		_lastError = DES_NO_FILE;;
		return 0;
	}
	HDLL pLib = _findLibrary(fullpath);
	if (pLib != 0)
	{
		pLib->refCnt++;
		pLib->pRegStruct->pEntryFunc(DllModeAddRef,0);
		return pLib;
	}
	pLib = new DllEntry();
	if (pLib != 0)
	{
		if (pLib->create(fullpath))
		   return pLib;
		delete pLib;
	}
	else
	   _lastError = DES_NO_MEMORY;
	return 0;
}

int FreeLibrary(HDLL hModule)
{
	for (HDLL p=_first;p != 0; p=p->pNext)
	{

		if (p == hModule)
		   return p->release();
	}
	_lastError = DES_INVALID_ARG;
	return -1;
}

PDLLPROC GetProcAddress(HDLL hModule, const char* lpProcName)
{
	if ((hModule == 0) || (lpProcName == 0))
	{
		_lastError = DES_INVALID_ARG;
		return 0;
	}
	DLLRegStruct* pRegStruct = hModule->pRegStruct;
   	DllExpEntry* entryArray = pRegStruct->entryArray;
    unsigned cnt = pRegStruct->entryCount;
    for (unsigned i=0;i<cnt;i++)
    {
		if (strcmp(entryArray[i].name,lpProcName) == 0)
		    return entryArray[i].pFunc;
	}
    _lastError = DES_NO_SYMBOL;
    return 0;
}

PDLLPROC GetEntryAt(HDLL hModule, int index)
{
	if (hModule ==0)
	{
		_lastError = DES_INVALID_ARG;
		return 0;
	}
	DLLRegStruct huge * pRegStruct = hModule->pRegStruct;
	if ((index < 0) || (index >= pRegStruct->entryCount))
	{
		_lastError = DES_INVALID_INDEX;
		return 0;
	}
	return pRegStruct->entryArray[index].pFunc;
}

DllErrState GetDllError()
{
	return _lastError;
}

int EnumExports(HDLL hModule, DllExpEnumFunc enumFunc)
{
	if ((hModule ==0) || (enumFunc == 0))
	{
		_lastError = DES_INVALID_ARG;
		return 0;
	}
	DLLRegStruct* pRegStruct = hModule->pRegStruct;
		DllExpEntry* entryArray = pRegStruct->entryArray;
    unsigned cnt = pRegStruct->entryCount;
    for (unsigned i=0;i<cnt;i++)
    {
		DllExpEntry* pEntry = &entryArray[i];
		if (!enumFunc(pEntry->name,pEntry->pFunc))
		    break;
	}
	return 1;
}
