#ifndef USEDLL_H
#define USEDLL_H



/* ****************************************************************************************
*                    DOSDLL - Dynamic Libraries for old MS-DOS
*   (c) 2007 by R.-Erik Ebert  -  ebert@kiezsoft.de
*   - Some ideas were borrowed from MikDLL (c) 1995 by Jean-Paul Mikkers (MikMak). -
*  This library is FREEWARE and provided without any kind of warrenty.
  *****************************************************************************************/

/** \file
                            USEDLL.H

 Use this header in implementation of your main application.

  Main application should be implemented as in followimg sample:
  It needs to be linked against (or compiled together with) USEDLL module.
  Please note that USEDLL module needs to be compiled as C++ (not C).

@code
#include <stdio.h>
#include "usedll.h"

typedef void (* FUNC0)();
typedef void (* FUNC1)(const char*);

int huge enumExpFunc(const char* name, PDLLPROC pExpEntry)
{
	printf("%s\n",name);
	return 1;
}

int main(int argc, char* argv[])
{
	HDLL hDll = LoadLibrary("testdll.dll");
    if (hDll == 0)
    {
		printf("error loding library\n");
		return 1;
	}
	FUNC0 sayHello = (FUNC0) GetProcAddress(hDll,"sayHello");
    if (sayHello == 0)
		printf("sayHello not found\n");
	else
	   sayHello();
	FUNC1 sayHello2 = (FUNC1) GetProcAddress(hDll,"sayHello(const char*)");
    if (sayHello2 == 0)
		printf("sayHello(const char*) not found\n");
	else
	   sayHello2("DllApp");
    printf("\nNow enumerate exports:\n");
    EnumExports(hDll,&enumExpFunc);
    if (FreeLibrary(hDll) < 0)
    {
       printf("Unloading library failed!\n");
       return 2;
    }
    return 0;
}
@endcode
*/



/** forward declaration of type DllEntry (declared in usedll.cpp) */
#ifdef __cplusplus
	struct DllEntry;
#else
	typedef struct DllEntry DllEntry;
#endif

#ifdef __DMC__
#define huge
#endif

/** DLL handle type */
typedef DllEntry huge * HDLL;

/** Type of pointer returned by GetProcAddress and GetEntryAt functions. */
#define PDLLPROC void huge*

/** Type of callback for enumeration of registered entries in a library module.
A function of this type must be passed to EnumExports function for second argument.
@param name Name of exported item
@param pExpEntry Address of exported function or data
@return Function should return a non-zero result to continue enumeration or
zero to cancel it.
@see EnumExports
*/
typedef int (huge *DllExpEnumFunc)(const char far* name, PDLLPROC pExpEntry);

/** Enum type of errors reported by library. */
typedef enum
{
	DES_OK = 0,
	DES_INVALID_ARG,
	DES_NO_MEMORY,
	DES_NO_FILE,
	DES_ERR_FOPEN,
	DES_ERR_FREAD,
	DES_ERR_LOADOVL,
	DES_NO_ENTRYPOINT,
	DES_NO_SYMBOL,
	DES_INVALID_INDEX,
	DES_UNKNOWN
} DllErrState;

#ifdef __cplusplus
extern "C" {
#endif
    /** Load library do process or increment its reference counter.
    Function tries to load specified library into currend proces space.
    Library is searched in current directory and path specified by PATH
    environment variable. If a library is already loaded function simply
    increments its reference counter.
    @param lpFileName Name of library file (with extension and optionally path specification)
    @return Library handle on success, otherwise NULL
    @note Library loaded by this function should be relased using FraaLibrary if no longer needed.
    */
    HDLL LoadLibrary(const char* lpFileName);

    /** Release library module.
    Function decrements internal reference counter of library module. If it becomes tero library is
    removed from memory.
    @param hModule Handle of module to release
    @return Number of references remaining on success, -1 on error
    */
    int FreeLibrary(HDLL hModule);

    /** Get address of exported function or data entry by name.
    Function returns address of an entry exported from dynamic library module.
    @param hModule Handle of library to get entry from.
    @param lpProcName Name of entry to get.
    @return Address of exported entry on success, otherwise NULL.
    @note Value returned is a pointer without any type information. You need to cast it to
    correct type before using.
    @see GetEntryAt
    */
    PDLLPROC GetProcAddress(HDLL hModule, const char* lpProcName);

    /** Get address of exported function or data entry by index.
    Function returns address of an entry exported from dynamic library module specified by index.
    @param hModule Handle of library to get entry from.
    @param Index of entry to get in libraries export table.
    @return Address of exported entry on success, otherwise NULL.
    @note This function works much faster than GetProcAddress. Use it if you know index of
    entry in export table.
    @see GetProcAddress
    */
    PDLLPROC GetEntryAt(HDLL hModule, int index);

    /** Get code of last error occured.
    This function may be called if one of other function failed in order to get
    information about error.
    @return error code
    */
    DllErrState GetDllError();

    /** Enumerator for exported entries.
    Function enumerates through export table of specified module and invokes
    callback for each of its entries. It may be useful for getting information about a library
    or retrieving idexes of its exported items.
    @param hModule Module handle of library to enumerate.
    @param enumFunc Callback function
    @return 1 on success, 0 on error
    @note Enumeration will be aborted if callback function returns zero.
    @see DllExpEnumFunc
    */
    int EnumExports(HDLL hModule, DllExpEnumFunc enumFunc);


#ifdef __cplusplus
}
#endif
#endif // USEDLL_H
