#ifndef AES_H
#define AES_H

#include <usedll.h>

#ifdef __TURBOC__
   #ifndef BOOLDEFINED
      #define BOOLDEFINED
      typedef enum
      {
		  false = 0,
		  true = 1
	  } bool;
   #endif
#endif
// defines of symbolic values

// types of lines
#define LS_SINGLE 0
#define LS_DOUBLE 1
#define LS_NONE 0xFF

// screen modes
#define SM_STATIC  0
#define SM_POFO    1
#define SM_DYNAMIC 2
#define SM_GRAPHIC 0x80

// cursor modes
#define CM_OFF       0
#define CM_UNDERLINE 1
#define CM_BLOCK     2
#define CM_REFLECT   3


typedef long (*getRomVersionProc)(long,char*);
typedef void (*drawBoxProc)(long,long);
typedef long (*showMenuProc)(char*,long,long,long);
typedef long (*showMessageProc)(char*,long,long);
typedef long (*showErrorProc)(char*,long,long);
typedef long (*getKeyProc)();
typedef long (*editStringProc)(long,char*,char*,long,long);
typedef long (*getScreenSizeProc)();
typedef long (*getScreenModeProc)();
typedef long (*setScreenModeProc)(long);
typedef long (*getInternalDiskSizeProc)();
typedef long (*getVScreenPosProc)();
typedef void (*setVScreenPosProc)(long,long);
typedef long (*getCursorModeProc)();
typedef long (*setCursorModeProc)(long);
typedef void (*setCursorPositionProc)(long,long,long);
typedef long (*getCursorPositionProc)(long);
typedef void (*setScrPageProc)(long);
typedef long (*getScrPageProc)();


/** BOB+ sample class for wrapping access to Atari Portfolio AES functions.
@func This class provides access to some of Atari Portfolio AES functions. Therefore uses the AES.EXE
dynamic library.
*/
class AES
{

public:
   /// ctor
   AES();
   /// dtor
   ~AES();

   // object internal getter/setter

   /// set line style attribute
   void setLineStyle(unsigned lineStyle);
   /// get line style attribute
   unsigned getLineStyle() const;
   /// set video page
   void setVideoPage(unsigned page);
   /// get video page
   unsigned getVideoPage() const;
   /// make video page active
   void activateScrPage(unsigned page);
   /// get currently active video page
   unsigned getActiveScrPage() const;

   /// get value of internal buffer
   const char* getBuffer() const;
   /// apply value to internal buffer
   void setBuffer(const char* str);
   // wrapped DLL functions

   /// get version string of BIOS-ROMs
   const char* getRomVersion();
   /// draw a box in text mode
   void drawBox(int x, int y, unsigned width, unsigned height);
   /// show a popup menu
   int showMenu(int x, int y,const char* desc,int selection);
   /// show message in a box
   unsigned showMessage(int x, int y, const char* msgText);
   /// edit single line string in a temporary window
   bool editString(int x, int y, unsigned width, bool hasBorder=true, const char* title=0,const char* prompt=0);
   /// show error message
   unsigned showError(int x, int y, const char* msgText);
   /// wait for key and get char/scan code
   unsigned getKey() const;
   /// get physical screen width
   unsigned getScrW() const;
   /// get physical screen height
   unsigned getScrH() const;
   /// get logical screen width
   unsigned getLogScrW() const;
   /// get logical screen height
   unsigned getLogScrH() const;
   /// get current screen mode
   unsigned getScrMode() const;
   /// set screen to specified mode
   unsigned setScrMode(unsigned mode);
   /// get size of internal RAM disk
   unsigned long getInternalDiskSize() const;
   /// get column position of virtual screen
   int getVScreenPosX() const;
   /// get row position of virtual screen
   int getVScreenPosY() const;
   /// set position of virtual screen
   void setVScreenPos(int x, int y);
   /// get cursor mode
   unsigned getCursorMode() const;
   /// set cursor mode
   unsigned setCursorMode(unsigned mode);
   /// get column position of cursoe
   int getCursorX() const;
   /// get row position of cursor
   int getCursorY() const;
   /// set cursor position
   void setCursorPos(int x, int y);

private:
   /// copy forbidden
   AES(const AES&);
   /// assignment forbidden
   AES& operator=(const AES&);

   // member variables
   /// DLL handle
   HDLL _hdll;

/** @name pointers to DLL functions. */
//@{
   getRomVersionProc _getVersion;
   drawBoxProc _drawBox;
   showMenuProc _showMenu;
   showMessageProc _showMessage;
   showErrorProc _showError;
   getKeyProc _getKey;
   getScreenSizeProc _getScrSize;
   getScreenModeProc _getScrMode;
   setScreenModeProc _setScrMode;
   editStringProc _editString;
   getInternalDiskSizeProc _getIntDiskSize;
   getVScreenPosProc _getVScreenPos;
   setVScreenPosProc _setVScreenPos;
   getCursorModeProc _getCursorMode;
   setCursorModeProc _setCursorMode;
   setCursorPositionProc _setCursorPos;
   getCursorPositionProc _getCursorPos;
   setScrPageProc _setScrPage;
   getScrPageProc _getScrPage;
//@}
   /// string buffer
   char* _strbuf;
   /// line style attribute
   unsigned _lineStyle;
   /// video page attribute
   unsigned _videoPage;

   /// static helper for rectangle encoding
   static long mkRect(int x, int y, unsigned width, unsigned height);
};

#endif // !AES_H

